/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.bam.BamError;
import com.caucho.bam.Message;
import com.caucho.bam.Query;
import com.caucho.bam.actor.SimpleActor;
import com.caucho.boot.PidQuery;
import com.caucho.boot.StartInfoMessage;
import com.caucho.boot.WatchdogStopQuery;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.jmx.Jmx;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.WarningMessage;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ResinActor
extends SimpleActor {
    private static final Logger log = Logger.getLogger(ResinActor.class.getName());
    private static final L10N L = new L10N(ResinActor.class);
    private Resin _resin;
    private ShutdownSystem _shutdown;

    ResinActor(Resin resin) {
        this._resin = resin;
        this.setAddress("resin");
        this._shutdown = ShutdownSystem.getCurrent();
        if (this._shutdown == null) {
            throw new IllegalStateException(L.l("'{0}' requires an active {1}.", (Object)this, (Object)ShutdownSystem.class.getSimpleName()));
        }
    }

    public void sendWarning(String msg) {
        try {
            this.getBroker().message("watchdog", this.getAddress(), new WarningMessage(msg));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Message
    public void startInfo(String to, String from, StartInfoMessage msg) {
        this._resin.setStartInfo(msg.isRestart(), msg.getRestartMessage(), msg.getPreviousExitCode());
    }

    @Query
    public void queryPid(long id, String to, String from, PidQuery query) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " " + query);
        }
        try {
            MBeanServer server = Jmx.getGlobalMBeanServer();
            ObjectName objName = new ObjectName("java.lang:type=Runtime");
            String runtimeName = (String)server.getAttribute(objName, "Name");
            if (runtimeName == null) {
                this.getBroker().queryError(id, from, to, query, new BamError("null runtime name"));
                return;
            }
            int p = runtimeName.indexOf(64);
            if (p > 0) {
                int pid = Integer.parseInt(runtimeName.substring(0, p));
                this.getBroker().queryResult(id, from, to, new PidQuery(pid));
                return;
            }
            this.getBroker().queryError(id, from, to, query, new BamError("malformed name=" + runtimeName));
        }
        catch (Exception e) {
            this.getBroker().queryError(id, from, to, query, BamError.create(e));
        }
    }

    @Query
    public void stop(long id, String to, String from, WatchdogStopQuery query) {
        log.info(this._resin + " stop request from watchdog '" + from + "'");
        String msg = L.l("Resin shutdown from watchdog stop '" + from + "'");
        this.getBroker().queryResult(id, from, to, query);
        ShutdownSystem.shutdownActive(ExitCode.OK, msg);
    }

    public void destroy() {
        String msg = L.l("Resin shutdown from unexpected watchdog exit.");
        ShutdownSystem.shutdownActive(ExitCode.WATCHDOG_EXIT, msg);
    }
}

