/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.config.ConfigAdmin;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ConfigMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.resin.MemoryAdmin;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ThreadPoolAdmin;
import com.caucho.server.util.CauchoSystem;
import java.util.Collection;

public class ResinAdmin
extends AbstractManagedObject
implements ResinMXBean {
    private final Resin _resin;
    private ThreadPoolAdmin _threadPoolAdmin;

    public ResinAdmin(Resin resin) {
        this._resin = resin;
        this.registerSelf();
        this._threadPoolAdmin = ThreadPoolAdmin.create();
        this._threadPoolAdmin.register();
        MemoryAdmin.create();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public ClusterMXBean[] getClusters() {
        CloudSystem system = TopologyService.getCurrentSystem();
        CloudCluster[] clusters = system.getClusterList();
        ClusterMXBean[] mxClusters = new ClusterMXBean[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            mxClusters[i] = clusters[i].getAdmin();
        }
        return mxClusters;
    }

    public ThreadPoolMXBean getThreadPoolAdmin() {
        return this._threadPoolAdmin;
    }

    @Override
    public ConfigMXBean[] getConfigs() {
        Collection<ConfigMXBean> beans = ConfigAdmin.getMBeans(this._resin.getClassLoader());
        ConfigMXBean[] array = new ConfigMXBean[beans.size()];
        beans.toArray(array);
        return array;
    }

    @Override
    public String getConfigFile() {
        return this._resin.getResinConf().getNativePath();
    }

    @Override
    public String getConfigDirectory() {
        return this._resin.getConfDirectory().getNativePath();
    }

    @Override
    public String getResinHome() {
        return this._resin.getResinHome().getNativePath();
    }

    @Override
    public String getRootDirectory() {
        return this._resin.getRootDirectory().getNativePath();
    }

    @Override
    public String getLogDirectory() {
        return this._resin.getLogDirectory().getNativePath();
    }

    @Override
    public String getDataDirectory() {
        return this._resin.getResinDataDirectory().getNativePath();
    }

    @Override
    public ServerMXBean getServer() {
        ServletService server = this._resin.getServer();
        if (server != null) {
            return server.getAdmin();
        }
        return null;
    }

    @Override
    public String getVersion() {
        return VersionFactory.getFullVersion();
    }

    @Override
    public boolean isProfessional() {
        return this._resin.isProfessional();
    }

    @Override
    public String getLocalHost() {
        return CauchoSystem.getLocalHost();
    }

    @Override
    public String getUserName() {
        return System.getProperty("user.name");
    }

    @Override
    public boolean isRestart() {
        return this._resin.isRestart();
    }

    @Override
    public String getWatchdogStartMessage() {
        return this._resin.getRestartMessage();
    }

    @Override
    public String toString() {
        return "ResinAdmin[" + this.getObjectName() + "]";
    }
}

