/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.host.Host;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthorizationResult;
import com.caucho.server.webapp.WebApp;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TransportConstraint
extends AbstractConstraint {
    private String _transport;

    public TransportConstraint() {
    }

    public TransportConstraint(String transport) {
        this._transport = transport;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this._transport = transportGuarantee;
    }

    @Override
    public boolean isPrivateCache() {
        return false;
    }

    @Override
    public AuthorizationResult isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        if (this._transport == null) {
            return AuthorizationResult.DEFAULT_ALLOW;
        }
        if (request.isSecure()) {
            return AuthorizationResult.DEFAULT_ALLOW;
        }
        WebApp webApp = (WebApp)application;
        Host host = webApp.getHost();
        String secureHost = host.getSecureHostName();
        if (secureHost != null) {
            String url = "https://" + secureHost + webApp.getContextPath() + request.getServletPath();
            if (request.getPathInfo() != null) {
                url = url + request.getPathInfo();
            }
            if (request.getQueryString() != null) {
                url = url + "?" + request.getQueryString();
            }
            response.sendRedirect(url);
            return AuthorizationResult.DENY_SENT_RESPONSE;
        }
        String url = request.getRequestURL().toString();
        if (url.startsWith("http:") && request.getServerPort() == 80) {
            url = "https:" + url.substring(5);
            String queryString = request.getQueryString();
            if (queryString != null) {
                response.sendRedirect(url + "?" + queryString);
            } else {
                response.sendRedirect(url);
            }
            return AuthorizationResult.DENY_SENT_RESPONSE;
        }
        response.sendError(403, null);
        return AuthorizationResult.DENY_SENT_RESPONSE;
    }
}

