/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class WebResourceCollection {
    static L10N L = new L10N(WebResourceCollection.class);
    public static final String[] _methods = new String[HttpMethod.values().length];
    private String _webResourceName;
    private String _description;
    private ArrayList<String> _methodList;
    private Set<String> _methodOmitList;
    private ArrayList<Pattern> _urlPatternList = new ArrayList();

    public void setWebResourceName(String name) {
        this._webResourceName = name;
    }

    public void setDescription(String name) {
        this._description = name;
    }

    public void addURLPattern(String pattern) throws PatternSyntaxException {
        String regexpPattern = UrlMap.urlPatternToRegexpPattern(pattern);
        int flags = CauchoSystem.isCaseInsensitive() ? 2 : 0;
        Pattern regexp = Pattern.compile(regexpPattern, flags);
        this._urlPatternList.add(regexp);
    }

    public ArrayList getURLPatternList() {
        return this._urlPatternList;
    }

    public void addMethod(String method) {
        if (this._methodList == null) {
            this._methodList = new ArrayList();
        }
        this._methodList.add(method);
    }

    public void addHttpMethod(String method) {
        if (!Pattern.matches("[a-zA-Z]+", method)) {
            throw new ConfigException(L.l("'{0}' is not a valid http-method.", (Object)method));
        }
        if (this._methodList == null) {
            this._methodList = new ArrayList();
        }
        this._methodList.add(method);
    }

    public void addHttpMethodOmission(String method) {
        if (!Pattern.matches("[a-zA-Z]+", method)) {
            throw new ConfigException(L.l("'{0}' is not a valid http-method.", (Object)method));
        }
        if (this._methodOmitList == null) {
            this._methodOmitList = new HashSet<String>();
        }
        this._methodOmitList.add(method);
    }

    public ArrayList<String> getMethods() {
        if (this._methodOmitList == null) {
            return this._methodList;
        }
        if (this._methodList == null) {
            this._methodList = new ArrayList(_methods.length - this._methodOmitList.size());
            for (String method : _methods) {
                if (this._methodOmitList.contains(method)) continue;
                this._methodList.add(method);
            }
        }
        return this._methodList;
    }

    public boolean isMatch(String url) {
        if (this._urlPatternList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this._urlPatternList.size(); ++i) {
            Pattern pattern = this._urlPatternList.get(i);
            if (!pattern.matcher(url).find()) continue;
            return true;
        }
        return false;
    }

    static {
        HttpMethod[] methods = HttpMethod.values();
        for (int i = 0; i < methods.length; ++i) {
            HttpMethod method = methods[i];
            WebResourceCollection._methods[i] = method.toString();
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE;

    }
}

