/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class HashChunkInputStream
extends InputStream {
    private static final L10N L = new L10N(HashChunkInputStream.class);
    private InputStream _next;
    private CRC32 _crc = new CRC32();
    private TempBuffer _tBuf;
    private byte[] _buffer;
    private boolean _isLast;
    private int _offset;
    private int _length;

    public HashChunkInputStream(InputStream next) {
        this._next = next;
        this._tBuf = TempBuffer.allocate();
        this._buffer = this._tBuf.getBuffer();
    }

    @Override
    public int read() throws IOException {
        if (this._length <= this._offset && !this.fillBuffer()) {
            return -1;
        }
        return this._buffer[this._offset++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int readLength = 0;
        while (length > 0) {
            int sublen = Math.min(length, this._length - this._offset);
            if (sublen <= 0 && !this.fillBuffer()) {
                return readLength > 0 ? readLength : -1;
            }
            System.arraycopy(this._buffer, this._offset, buffer, offset, sublen);
            length -= sublen;
            this._offset += sublen;
            offset += sublen;
            readLength += sublen;
        }
        return readLength;
    }

    @Override
    public void close() throws IOException {
        this._next.close();
    }

    private boolean fillBuffer() throws IOException {
        int sublen;
        InputStream is = this._next;
        if (is == null || this._isLast) {
            return false;
        }
        byte[] buffer = this._buffer;
        int len0 = is.read();
        int len1 = is.read();
        if (len1 < 0) {
            return false;
        }
        buffer[0] = (byte)len0;
        buffer[1] = (byte)len1;
        this._isLast = (len0 & 0x80) != 0;
        int len = ((len0 &= 0x7F) << 8) + len1;
        int end = len + 4;
        for (int offset = 2; offset < end; offset += sublen) {
            sublen = is.read(buffer, offset, end - offset);
            if (sublen >= 0) continue;
            return false;
        }
        this._crc.update(buffer, 0, end - 4);
        long digest = this._crc.getValue();
        long readDigest = (((long)buffer[end - 4] & 0xFFL) << 24) + (((long)buffer[end - 3] & 0xFFL) << 16) + (((long)buffer[end - 2] & 0xFFL) << 8) + (((long)buffer[end - 1] & 0xFFL) << 0);
        if (digest != readDigest) {
            this._isLast = true;
            this._offset = 0;
            this._length = 0;
            throw new IOException(L.l("Mismatch crc read={0} calc={1}", (Object)Long.toHexString(readDigest), (Object)Long.toHexString(digest)));
        }
        this._offset = 2;
        this._length = end - 4;
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._next + "]";
    }
}

