/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.network.listen.SocketLink;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.webapp.CauchoFilterChain;
import com.caucho.server.webapp.WebApp;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessLogFilterChain
implements CauchoFilterChain {
    private static final Logger log = Logger.getLogger(AccessLogFilterChain.class.getName());
    private final FilterChain _next;
    private final WebApp _webApp;
    private final AbstractAccessLog _accessLog;

    public AccessLogFilterChain(FilterChain next, WebApp webApp) {
        this._next = next;
        this._webApp = webApp;
        this._accessLog = webApp.getAccessLog();
    }

    @Override
    public FilterChain getNext() {
        return this._next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this._next.doFilter(request, response);
        SocketLink socketLink = null;
        if (request instanceof CauchoRequest) {
            socketLink = ((CauchoRequest)request).getSocketLink();
        }
        try {
            if (socketLink != null) {
                socketLink.requestShutdownBegin();
            }
            this._accessLog.log((HttpServletRequest)request, (HttpServletResponse)response, this._webApp);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (socketLink != null) {
                socketLink.requestShutdownEnd();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp.getURL() + ", next=" + this._next + "]";
    }
}

