/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.Period;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;

public class CacheMapping {
    static L10N L = new L10N(CacheMapping.class);
    private String _urlPattern;
    private String _urlRegexp;
    private long _maxAge = Long.MIN_VALUE;
    private long _sMaxAge = Long.MIN_VALUE;

    public void setUrlPattern(String urlPattern) {
        this._urlPattern = urlPattern;
    }

    public String getUrlPattern() {
        return this._urlPattern;
    }

    public void setUrlRegexp(String urlRegexp) {
        this._urlRegexp = urlRegexp;
    }

    public String getUrlRegexp() {
        return this._urlRegexp;
    }

    public void setExpires(Period period) {
        this.setMaxAge(period);
    }

    public void setMaxAge(Period period) {
        this._maxAge = period.getPeriod();
    }

    public long getMaxAge() {
        return this._maxAge;
    }

    public void setSMaxAge(Period period) {
        this._sMaxAge = period.getPeriod();
    }

    public long getSMaxAge() {
        return this._sMaxAge;
    }

    @PostConstruct
    public void init() throws ServletException {
        if (this._urlPattern == null && this._urlRegexp == null) {
            throw new ServletException(L.l("cache-mapping needs 'url-pattern' attribute."));
        }
        if (this._maxAge == Long.MIN_VALUE && this._sMaxAge == Long.MIN_VALUE) {
            throw new ServletException(L.l("cache-mapping needs 'max-age' attribute."));
        }
    }
}

