/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.JdbcDriverMXBean;
import com.caucho.sql.DriverConfig;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DriverAdmin
extends AbstractManagedObject
implements JdbcDriverMXBean {
    private static final Logger log = Logger.getLogger(DriverAdmin.class.getName());
    private DriverConfig _driver;

    public DriverAdmin(DriverConfig driver) {
        this._driver = driver;
    }

    @Override
    public String getName() {
        return this._driver.getDBPool().getName();
    }

    @Override
    public String getClassName() {
        return this._driver.getType();
    }

    @Override
    public String getUrl() {
        Properties props = this.getProperties();
        String url = (String)props.get("url");
        if (url != null) {
            return url;
        }
        return this._driver.getURL();
    }

    @Override
    public Properties getProperties() {
        try {
            Properties props = new Properties();
            Object driverObject = this._driver.getDriverObject();
            if (driverObject == null) {
                return props;
            }
            BeanInfo info = Introspector.getBeanInfo(driverObject.getClass());
            for (PropertyDescriptor property : info.getPropertyDescriptors()) {
                Method getter;
                String name = property.getName();
                if (name.equalsIgnoreCase("url")) {
                    name = "url";
                }
                if ((getter = property.getReadMethod()) == null || property.getWriteMethod() == null) continue;
                try {
                    Object value = getter.invoke(driverObject, new Object[0]);
                    if (name.equalsIgnoreCase("password")) {
                        value = "****";
                    }
                    if (value == null) continue;
                    props.put(name, String.valueOf(value));
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            return props;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void addObjectNameProperties(Map<String, String> props) throws MalformedObjectNameException {
        String url = this.getUrl();
        if (url != null) {
            if (url.indexOf(58) >= 0) {
                url = ObjectName.quote(url);
            }
            props.put("url", url);
        }
    }

    @Override
    public String getState() {
        return this._driver.getLifecycle().getStateName();
    }

    @Override
    public long getConnectionCountTotal() {
        return this._driver.getConnectionCountTotal();
    }

    @Override
    public long getConnectionFailCountTotal() {
        return this._driver.getConnectionFailCountTotal();
    }

    @Override
    public Date getLastFailTime() {
        return new Date(this._driver.getLastFailTime());
    }

    @Override
    public boolean start() {
        return this._driver.start();
    }

    @Override
    public boolean stop() {
        return this._driver.stop();
    }

    void register() {
        this.registerSelf();
    }

    @Override
    public String toString() {
        return "JdbcDriverAdmin[" + this.getObjectName() + "]";
    }
}

