/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.RingValueQueue;

public final class FreeRing<T> {
    private final RingValueQueue<T> _ringQueue;

    public FreeRing(int capacity) {
        this._ringQueue = new RingValueQueue(capacity);
    }

    public int getSize() {
        return this._ringQueue.size();
    }

    public long getHead() {
        return this._ringQueue.getHead();
    }

    public long getHeadAlloc() {
        return this._ringQueue.getHeadAlloc();
    }

    public long getTail() {
        return this._ringQueue.getTail();
    }

    public long getTailAlloc() {
        return this._ringQueue.getTail();
    }

    public T allocate() {
        return (T)this._ringQueue.poll();
    }

    public boolean free(T value) {
        return this._ringQueue.offer(value);
    }

    public boolean freeCareful(T value) {
        if (this.checkDuplicate(value)) {
            throw new IllegalStateException("tried to free object twice: " + value);
        }
        return this.free(value);
    }

    public boolean checkDuplicate(T obj) {
        return false;
    }
}

