/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.config.ConfigException;
import com.caucho.util.CurrentTime;
import com.caucho.util.TimedCache;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HostUtil {
    private static final Logger log = Logger.getLogger(HostUtil.class.getName());
    private static final TimedCache<String, ArrayList<NetworkInterface>> _cache;

    private HostUtil() {
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        for (InetAddress addr : HostUtil.getLocalAddresses()) {
            if (!HostUtil.isPrivateNetwork(addr)) continue;
            return addr.getHostAddress();
        }
        return "127.0.0.1";
    }

    public static String getLocalHostAddress() {
        for (InetAddress addr : HostUtil.getLocalAddresses()) {
            if (!HostUtil.isPrivateNetwork(addr)) continue;
            return addr.getHostAddress();
        }
        return "127.0.0.1";
    }

    public static boolean isPrivateNetwork(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        if (bytes.length != 4) {
            return false;
        }
        if (bytes[0] == 10) {
            return true;
        }
        if ((bytes[0] & 0xFF) == 172 && 16 <= bytes[1] && bytes[1] <= 31) {
            return true;
        }
        return (bytes[0] & 0xFF) == 192 && (bytes[1] & 0xFF) == 168;
    }

    public static boolean isLinkLocalNetwork(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        if (bytes.length != 4) {
            return false;
        }
        return (bytes[0] & 0xFF) == 169 && (bytes[1] & 0xFF) == 254;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<InetAddress> getLocalAddresses() {
        ArrayList<InetAddress> localAddresses = new ArrayList<InetAddress>();
        Class<HostUtil> clazz = HostUtil.class;
        synchronized (HostUtil.class) {
            try {
                for (NetworkInterface iface : HostUtil.getNetworkInterfaces()) {
                    Enumeration<InetAddress> addrEnum = iface.getInetAddresses();
                    while (addrEnum.hasMoreElements()) {
                        InetAddress addr = addrEnum.nextElement();
                        localAddresses.add(addr);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            Collections.sort(localAddresses, new LocalIpCompare());
            return localAddresses;
        }
    }

    public static synchronized ArrayList<NetworkInterface> getNetworkInterfaces() {
        ArrayList<NetworkInterface> interfaceList = _cache.get("network-interfaces");
        if (interfaceList == null) {
            interfaceList = new ArrayList();
            try {
                Enumeration<NetworkInterface> ifaceEnum = NetworkInterface.getNetworkInterfaces();
                while (ifaceEnum.hasMoreElements()) {
                    NetworkInterface iface = ifaceEnum.nextElement();
                    interfaceList.add(iface);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            _cache.put("network-interfaces", interfaceList);
        }
        return new ArrayList<NetworkInterface>(interfaceList);
    }

    static {
        long timeout = CurrentTime.isTest() ? Integer.MAX_VALUE : 120000L;
        _cache = new TimedCache(128, timeout);
    }

    static class LocalIpCompare
    implements Comparator<InetAddress> {
        LocalIpCompare() {
        }

        @Override
        public int compare(InetAddress a, InetAddress b) {
            byte[] bytesB;
            byte[] bytesA = a.getAddress();
            if (bytesA[0] != (bytesB = b.getAddress())[0]) {
                if (bytesA[0] == 0) {
                    return 1;
                }
                if (bytesB[0] == 0) {
                    return -1;
                }
                if (bytesA[0] == 127) {
                    return 1;
                }
                if (bytesB[0] == 127) {
                    return -1;
                }
            }
            if (bytesA.length != bytesB.length) {
                return bytesA.length - bytesB.length;
            }
            for (int i = 0; i < bytesA.length; ++i) {
                if (bytesA[i] == bytesB[i]) continue;
                return bytesA[i] - bytesB[i];
            }
            return 0;
        }
    }
}

