/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class LongKeyMap {
    private static final int DELETED = 1;
    private static final long DEAD_KEY = -2401053088335148290L;
    private long[] keys;
    private Object[] values;
    private byte[] flags;
    private int size;
    private int mask;

    public LongKeyMap() {
        this.keys = new long[16];
        this.values = new Object[16];
        this.flags = new byte[16];
        this.mask = this.keys.length - 1;
        this.size = 0;
        this.clear();
    }

    private LongKeyMap(boolean dummy) {
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.keys[i] = -2401053088335148290L;
            this.flags[i] = 0;
            this.values[i] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public Object get(long key) {
        int hash = (int)(key & (long)this.mask);
        long mapKey;
        while ((mapKey = this.keys[hash]) != key) {
            if (mapKey == -2401053088335148290L && (this.flags[hash] & 1) == 0) {
                return null;
            }
            hash = hash + 1 & this.mask;
        }
        return this.values[hash];
    }

    private void resize(int newSize) {
        int i;
        long[] newKeys = new long[newSize];
        Object[] newValues = new Object[newSize];
        byte[] newFlags = new byte[newSize];
        for (i = 0; i < newSize; ++i) {
            newKeys[i] = -2401053088335148290L;
        }
        this.mask = newKeys.length - 1;
        block1: for (i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == -2401053088335148290L || (this.flags[i] & 1) != 0) continue;
            int hash = (int)this.keys[i] & this.mask;
            while (true) {
                if (newKeys[hash] == -2401053088335148290L) {
                    newKeys[hash] = this.keys[i];
                    newValues[hash] = this.values[i];
                    newFlags[hash] = this.flags[i];
                    continue block1;
                }
                hash = hash + 1 & this.mask;
            }
        }
        this.keys = newKeys;
        this.values = newValues;
        this.flags = newFlags;
    }

    public Object put(long key, Object value) {
        int hash = (int)(key & (long)this.mask);
        int count = this.size;
        while (count-- >= 0) {
            long testKey = this.keys[hash];
            if (testKey == -2401053088335148290L || (this.flags[hash] & 1) != 0) {
                this.keys[hash] = key;
                this.values[hash] = value;
                this.flags[hash] = 0;
                ++this.size;
                if (this.keys.length <= 2 * this.size) {
                    this.resize(2 * this.keys.length);
                }
                return null;
            }
            if (key != testKey) {
                hash = hash + 1 & this.mask;
                continue;
            }
            Object old = this.values[hash];
            this.values[hash] = value;
            return old;
        }
        return null;
    }

    public Object remove(long key) {
        int hash = (int)(key & (long)this.mask);
        long mapKey;
        while ((mapKey = this.keys[hash]) != -2401053088335148290L) {
            if (mapKey == key) {
                int n = hash;
                this.flags[n] = (byte)(this.flags[n] | 1);
                --this.size;
                this.keys[hash] = -2401053088335148290L;
                return this.values[hash];
            }
            hash = hash + 1 & this.mask;
        }
        return null;
    }

    public Iterator iterator() {
        return new LongKeyMapIterator();
    }

    public Object clone() {
        LongKeyMap clone = new LongKeyMap(true);
        clone.keys = new long[this.keys.length];
        System.arraycopy(this.keys, 0, clone.keys, 0, this.keys.length);
        clone.values = new Object[this.values.length];
        System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        clone.flags = new byte[this.flags.length];
        System.arraycopy(this.flags, 0, clone.flags, 0, this.flags.length);
        clone.mask = this.mask;
        clone.size = this.size;
        return clone;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("LongKeyMap[");
        boolean isFirst = true;
        for (int i = 0; i <= this.mask; ++i) {
            if ((this.flags[i] & 1) != 0 || this.keys[i] == -2401053088335148290L) continue;
            if (!isFirst) {
                sbuf.append(", ");
            }
            isFirst = false;
            sbuf.append(this.keys[i]);
            sbuf.append(":");
            sbuf.append(this.values[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    class LongKeyMapIterator
    implements Iterator {
        int index;

        LongKeyMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < LongKeyMap.this.keys.length) {
                if (LongKeyMap.this.keys[this.index] != -2401053088335148290L && (LongKeyMap.this.flags[this.index] & 1) == 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            while (this.index < LongKeyMap.this.keys.length) {
                if (LongKeyMap.this.keys[this.index] != -2401053088335148290L && (LongKeyMap.this.flags[this.index] & 1) == 0) {
                    return new Long(LongKeyMap.this.keys[this.index++]);
                }
                ++this.index;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new RuntimeException();
        }
    }
}

