/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class Tree {
    private Tree parent;
    private Tree next;
    private Tree previous;
    private Tree first;
    private Tree last;
    private Object data;

    public Tree(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Tree getParent() {
        return this.parent;
    }

    public Tree getNext() {
        return this.next;
    }

    public Tree getNextPreorder() {
        if (this.first != null) {
            return this.first;
        }
        Tree ptr = this;
        while (ptr != null) {
            if (ptr.next != null) {
                return ptr.next;
            }
            ptr = ptr.parent;
        }
        return null;
    }

    public Tree getPreviousPreorder() {
        Tree ptr = this.previous;
        if (ptr != null) {
            while (ptr.last != null) {
                ptr = ptr.last;
            }
            return ptr;
        }
        return this.parent;
    }

    public Tree getPrevious() {
        return this.previous;
    }

    public Tree getFirst() {
        return this.first;
    }

    public Tree getLast() {
        return this.last;
    }

    public Tree append(Object data) {
        Tree child = new Tree(data);
        child.parent = this;
        child.previous = this.last;
        if (this.last != null) {
            this.last.next = child;
        } else {
            this.first = child;
        }
        this.last = child;
        return this.last;
    }

    public void appendTree(Tree child) {
        Tree subChild = this.append(child.getData());
        for (child = child.getFirst(); child != null; child = child.getNext()) {
            subChild.appendTree(child);
        }
    }

    public Iterator children() {
        return new ChildIterator(this.first);
    }

    public Iterator dfs() {
        return new DfsIterator(this.first);
    }

    public Iterator iterator() {
        return new ChildDataIterator(this.first);
    }

    static class DfsIterator
    implements Iterator {
        private Tree top;
        private Tree node;

        DfsIterator(Tree top) {
            this.top = top;
            this.node = top;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            Tree next = this.node;
            if (this.node != null) {
                this.node = this.node.getNextPreorder();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ChildDataIterator
    implements Iterator {
        private Tree node;

        ChildDataIterator(Tree child) {
            this.node = child;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            Tree next = this.node;
            if (this.node != null) {
                this.node = this.node.getNext();
            }
            return next == null ? null : next.data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ChildIterator
    implements Iterator {
        private Tree node;

        ChildIterator(Tree child) {
            this.node = child;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            Tree next = this.node;
            if (this.node != null) {
                this.node = this.node.getNext();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

