/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.BindPath;
import com.caucho.vfs.DatastoreFile;
import com.caucho.vfs.DatastoreInputStream;
import com.caucho.vfs.DatastoreOutputStream;
import com.caucho.vfs.DatastoreRandomAccessFile;
import com.caucho.vfs.DatastoreRandomAccessStream;
import com.caucho.vfs.DatastoreReadStream;
import com.caucho.vfs.DatastoreWriteStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class DatastorePath
extends Path {
    private static byte[] NEWLINE = DatastorePath.getNewlineString().getBytes();
    public static final boolean IS_USE_HASHMAP = false;
    private static HashMap<String, DatastoreFile> _fileMap = new HashMap();
    private static DatastorePath PWD;
    protected DatastorePath _root;
    protected BindPath _bindRoot;
    private String _pathname;
    private DatastoreFile _file;
    @PersistenceContext(name="test")
    private EntityManager _entityManager;

    public DatastorePath(String path) {
        this(null, path);
        if (this._root == null) {
            this._root._root = this._root = new DatastorePath(null, "/");
            if (PWD == null) {
                PWD = this._root;
            }
        }
    }

    protected DatastorePath(DatastorePath root, String pathname) {
        super(root);
        if (pathname == null) {
            throw new NullPointerException();
        }
        this._pathname = pathname;
        if (root != null) {
            this._root = root;
            this._bindRoot = root._bindRoot;
        }
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public static DatastoreFile getFile(String name) {
        DatastorePath path = new DatastorePath(null, name);
        EntityManager em = path._entityManager;
        Query query = em.createQuery("SELECT FROM " + DatastoreFile.class + " WHERE _pathname = :name");
        query.setParameter("name", (Object)name);
        List resultList = query.getResultList();
        if (resultList.size() == 0) {
            return null;
        }
        DatastoreFile file = (DatastoreFile)resultList.get(0);
        file.setPath(path);
        return file;
    }

    public static void dumpFiles() {
        DatastorePath path = PWD;
        if (PWD == null) {
            path = new DatastorePath(null, "/");
        }
        Query query = path._entityManager.createQuery("SELECT FROM " + DatastoreFile.class);
        List resultList = query.getResultList();
        System.out.println("DatastorePath->dumpFiles(): " + resultList.size());
        for (Object obj : resultList) {
            DatastoreFile file = (DatastoreFile)obj;
            System.out.println("\t" + file.getPathname());
        }
    }

    @Override
    public String getPath() {
        return this._pathname;
    }

    @Override
    public boolean exists() {
        EntityManager em = this._entityManager;
        Query query = em.createQuery("SELECT FROM " + DatastoreFile.class + " WHERE _pathname = :name");
        query.setParameter("name", (Object)this._pathname);
        List resultList = query.getResultList();
        return resultList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove() throws IOException {
        EntityManager em = this._entityManager;
        Query query = em.createQuery("SELECT FROM " + DatastoreFile.class + " WHERE _pathname = :name");
        query.setParameter("name", (Object)this._pathname);
        List resultList = query.getResultList();
        try {
            em.getTransaction().begin();
            for (Object obj : resultList) {
                this._entityManager.remove(obj);
            }
        }
        finally {
            this._entityManager.getTransaction().commit();
        }
        this._file = null;
        return true;
    }

    @Override
    public String getScheme() {
        return "datastore";
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        DatastoreInputStream is = new DatastoreInputStream(this.getDatastoreFile());
        return new DatastoreReadStream(is, this);
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        DatastoreOutputStream os = new DatastoreOutputStream(this.getDatastoreFile());
        DatastoreWriteStream ws = new DatastoreWriteStream(os, this);
        ws.setNewline(NEWLINE);
        return ws;
    }

    @Override
    public DatastoreRandomAccessStream openRandomAccess() throws IOException {
        DatastoreRandomAccessFile file = new DatastoreRandomAccessFile(this.getDatastoreFile());
        return new DatastoreRandomAccessStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreFile getDatastoreFile() {
        if (this._file != null) {
            return this._file;
        }
        EntityManager em = this._entityManager;
        Query query = em.createQuery("SELECT FROM " + DatastoreFile.class + " WHERE _pathname = :path");
        query.setParameter("path", (Object)this._pathname);
        List resultList = query.getResultList();
        if (resultList.size() != 0) {
            this._file = (DatastoreFile)resultList.get(0);
        } else {
            em.getTransaction().begin();
            try {
                this._file = new DatastoreFile(this._pathname);
                em.persist((Object)this._file);
            }
            finally {
                em.getTransaction().commit();
            }
        }
        this._file.setPath(this);
        return this._file;
    }

    @Override
    public Path schemeWalk(String userPath, Map<String, Object> attributes, String filePath, int offset) {
        if (!DatastorePath.isWindows()) {
            return this.schemeWalkImpl(userPath, attributes, filePath, offset);
        }
        if (filePath.length() < offset + 2) {
            return this.schemeWalkImpl(userPath, attributes, filePath, offset);
        }
        char ch1 = filePath.charAt(offset + 1);
        char ch2 = filePath.charAt(offset);
        if (!(ch2 != '/' && ch2 != _separatorChar || ch1 != '/' && ch1 != _separatorChar)) {
            return this.schemeWalkImpl(userPath, attributes, filePath.substring(offset), 0);
        }
        return this.schemeWalkImpl(userPath, attributes, filePath, offset);
    }

    protected Path schemeWalkImpl(String userPath, Map<String, Object> attributes, String filePath, int offset) {
        String canonicalPath = filePath.length() > offset && (filePath.charAt(offset) == '/' || filePath.charAt(offset) == _separatorChar) ? DatastorePath.normalizePath("/", filePath, offset, _separatorChar) : DatastorePath.normalizePath(this._pathname, filePath, offset, _separatorChar);
        return this.fsWalk(userPath, attributes, canonicalPath);
    }

    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        return new DatastorePath(this._root, path);
    }

    protected static String normalizePath(String oldPath, String newPath, int offset, char separatorChar) {
        CharBuffer cb = new CharBuffer();
        DatastorePath.normalizePath(cb, oldPath, newPath, offset, separatorChar);
        return cb.toString();
    }

    protected static void normalizePath(CharBuffer cb, String oldPath, String newPath, int offset, char separatorChar) {
        cb.clear();
        cb.append(oldPath);
        if (cb.length() == 0 || cb.getLastChar() != '/') {
            cb.append('/');
        }
        int length = newPath.length();
        int i = offset;
        block8: while (i < length) {
            char ch2;
            char ch = newPath.charAt(i);
            switch (ch) {
                default: {
                    if (ch != separatorChar) {
                        cb.append(ch);
                        ++i;
                        continue block8;
                    }
                }
                case '/': {
                    if (cb.getLastChar() != '/') {
                        cb.append('/');
                    }
                    ++i;
                    continue block8;
                }
                case '.': 
            }
            if (cb.getLastChar() != '/') {
                cb.append('.');
                ++i;
                continue;
            }
            if (i + 1 >= length) {
                i += 2;
                continue;
            }
            switch (newPath.charAt(i + 1)) {
                default: {
                    if (newPath.charAt(i + 1) != separatorChar) {
                        cb.append('.');
                        ++i;
                        continue block8;
                    }
                }
                case '/': {
                    i += 2;
                    continue block8;
                }
                case '.': 
            }
            if ((i + 2 >= length || (ch2 = newPath.charAt(i + 2)) == '/' || ch2 == separatorChar) && cb.getLastChar() == '/') {
                int segment = cb.lastIndexOf('/', cb.length() - 2);
                if (segment == -1) {
                    cb.clear();
                    cb.append('/');
                } else {
                    cb.setLength(segment + 1);
                }
                i += 3;
                continue;
            }
            cb.append('.');
            ++i;
        }
    }

    @Override
    public String toString() {
        return "DatastorePath[" + this._pathname + "," + this._file + "]";
    }
}

