/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.VfsStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileWriteStream
extends VfsStream
implements LockableStream {
    private FileOutputStream _os;
    private FileLock _fileLock;
    private FileChannel _fileChannel;
    private static final Logger log = Logger.getLogger(FileWriteStream.class.getName());

    public FileWriteStream(FileOutputStream fos) {
        super(null, fos);
        this._os = fos;
    }

    public FileWriteStream(FileOutputStream fos, Path path) {
        super(null, fos, path);
        this._os = fos;
    }

    @Override
    public void close() throws IOException {
        this.unlock();
        this._fileChannel = null;
        super.close();
    }

    @Override
    public boolean lock(boolean shared, boolean block) {
        this.unlock();
        if (shared) {
            return false;
        }
        try {
            if (this._fileChannel == null) {
                this._fileChannel = this._os.getChannel();
            }
            this._fileLock = block ? this._fileChannel.lock(0L, Long.MAX_VALUE, false) : this._fileChannel.tryLock(0L, Long.MAX_VALUE, false);
            return this._fileLock != null;
        }
        catch (OverlappingFileLockException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    @Override
    public boolean unlock() {
        try {
            FileLock lock = this._fileLock;
            this._fileLock = null;
            if (lock != null) {
                lock.release();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    @Override
    public void seekStart(long pos) throws IOException {
        if (this._fileChannel == null) {
            this._fileChannel = this._os.getChannel();
        }
        this._fileChannel.position(pos);
    }
}

