/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.ClientTimeoutException;
import com.caucho.vfs.JniSocketImpl;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InterruptedIOException;

@Module
public class JniStream
extends StreamImpl {
    private static final L10N L = new L10N(JniStream.class);
    private static final int INTERRUPT_EXN = -2;
    private static final int DISCONNECT_EXN = -3;
    public static final int TIMEOUT_EXN = -4;
    private static NullPath NULL_PATH;
    private final JniSocketImpl _socket;
    private IOException _readException;
    private long _totalReadBytes;
    private long _totalWriteBytes;

    public JniStream(JniSocketImpl socket) {
        this._socket = socket;
        if (NULL_PATH == null) {
            NULL_PATH = new NullPath("jni-stream");
        }
        this.setPath(NULL_PATH);
    }

    public void init() {
        this._readException = null;
    }

    @Override
    public boolean canRead() {
        return !this._socket.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this._socket.isClosed();
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._readException != null) {
            throw this._readException;
        }
        int result = this._socket.read(buf, offset, length, -1L);
        if (result > 0) {
            this._totalReadBytes += (long)result;
            return result;
        }
        if (result < -1) {
            if (result == -4) {
                this._socket.close();
            }
            this._readException = this.exception(result);
            throw this._readException;
        }
        if (length == 0 && result == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public int readTimeout(byte[] buf, int offset, int length, long timeout) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this._socket.read(buf, offset, length, timeout);
        if (result > 0) {
            this._totalReadBytes += (long)result;
            return result;
        }
        if (result == -4) {
            return -4;
        }
        if (result < -1) {
            throw this.exception(result);
        }
        return -1;
    }

    @Override
    public int getAvailable() throws IOException {
        return this.isEof() ? -1 : 1;
    }

    @Override
    public boolean isEof() throws IOException {
        return this._socket.isEof();
    }

    @Override
    public boolean canWrite() {
        return !this._socket.isClosed();
    }

    @Override
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (length <= 0) {
            return;
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this._socket.write(buf, offset, length, isEnd);
        if (result < -1) {
            throw this.exception(result);
        }
        if (result == -1) {
            throw new ClientDisconnectException(L.l("unexpected end of file in write"));
        }
        this._totalWriteBytes += (long)result;
    }

    @Override
    public boolean isMmapEnabled() {
        return this._socket.isMmapEnabled();
    }

    @Override
    public void writeMmap(long mmapAddress, long[] mmapBlocks, long mmapOffset, long mmapLength) throws IOException {
        this._socket.writeMmap(mmapAddress, mmapBlocks, mmapOffset, mmapLength);
    }

    @Override
    public boolean isSendfileEnabled() {
        return this._socket.isSendfileEnabled();
    }

    @Override
    public void writeSendfile(byte[] buffer, int offset, int length, byte[] fileName, int nameLength, long fileLength) throws IOException {
        this._socket.writeSendfile(buffer, offset, length, fileName, nameLength, fileLength);
    }

    @Override
    public void flush() throws IOException {
        this._socket.flush();
    }

    public long getTotalReadBytes() {
        return this._totalReadBytes;
    }

    public long getTotalWriteBytes() {
        return this._totalWriteBytes;
    }

    IOException exception(int result) throws IOException {
        switch (result) {
            case -2: {
                return new InterruptedIOException("interrupted i/o");
            }
            case -3: {
                return new ClientDisconnectException("connection reset by peer");
            }
            case -4: {
                return new ClientTimeoutException("client timeout");
            }
        }
        return new ClientDisconnectException("unknown exception=" + result);
    }

    @Override
    public void close() throws IOException {
        this._socket.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._socket + "]";
    }
}

