/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryStream
extends StreamImpl {
    private TempBuffer _head;
    private TempBuffer _tail;

    @Override
    public Path getPath() {
        return new NullPath("temp:");
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        while (offset < length) {
            int sublen;
            if (this._tail == null || this._tail._length >= this._tail._buf.length) {
                this.addBuffer(TempBuffer.allocate());
            }
            if (length - offset < (sublen = this._tail._buf.length - this._tail._length)) {
                sublen = length - offset;
            }
            System.arraycopy(buf, offset, this._tail._buf, this._tail._length, sublen);
            offset += sublen;
            this._tail._length += sublen;
        }
    }

    private void addBuffer(TempBuffer buf) {
        buf._next = null;
        buf._length = 0;
        if (this._tail != null) {
            this._tail._next = buf;
            this._tail = buf;
        } else {
            this._tail = buf;
            this._head = buf;
        }
        ++this._head._bufferCount;
    }

    public void writeToStream(OutputStream os) throws IOException {
        TempBuffer node = this._head;
        while (node != null) {
            os.write(node._buf, 0, node._length);
            node = node._next;
        }
    }

    public int getLength() {
        if (this._tail == null) {
            return 0;
        }
        return (this._head._bufferCount - 1) * this._head._length + this._tail._length;
    }

    public ReadStream openReadAndSaveBuffer() throws IOException {
        this.close();
        TempReadStream read = new TempReadStream(this._head);
        read.setFreeWhenDone(false);
        return new ReadStream(read);
    }

    public void destroy() {
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        while (ptr != null) {
            TempBuffer next = ptr._next;
            TempBuffer.free(ptr);
            ptr = null;
            ptr = next;
        }
    }
}

