/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.util.IntMap;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.SocketChannelStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@Module
public class QSocketChannelWrapper
extends QSocket {
    private static final Logger log = Logger.getLogger(QSocketChannelWrapper.class.getName());
    private static Class<?> sslSocketClass;
    private static IntMap sslKeySizes;
    private SocketChannel _channel;
    private ByteBuffer _byteBuffer = ByteBuffer.allocate(TempBuffer.SIZE);
    private byte[] _buffer;
    private SocketChannelStream _streamImpl;

    public QSocketChannelWrapper() {
    }

    public QSocketChannelWrapper(SocketChannel s) {
        this();
        this.init(s);
    }

    public void init(SocketChannel channel) {
        this._channel = channel;
    }

    @Override
    public Socket getSocket() {
        return this._channel.socket();
    }

    @Override
    public int acceptInitialRead(byte[] buffer, int offset, int length) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setReadTimeout(int ms) throws IOException {
        this.getSocket().setSoTimeout(ms);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getSocket().getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (this._channel != null) {
            return this.getSocket().getInetAddress();
        }
        return null;
    }

    @Override
    public int getRemotePort() {
        if (this._channel != null) {
            return this.getSocket().getPort();
        }
        return 0;
    }

    @Override
    public boolean isSecure() {
        if (this._channel == null || sslSocketClass == null) {
            return false;
        }
        return sslSocketClass.isAssignableFrom(this.getSocket().getClass());
    }

    @Override
    public String getCipherSuite() {
        if (!(this.getSocket() instanceof SSLSocket)) {
            return super.getCipherSuite();
        }
        SSLSocket sslSocket = (SSLSocket)this.getSocket();
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    @Override
    public String getSslProtocol() {
        if (!(this.getSocket() instanceof SSLSocket)) {
            return super.getCipherSuite();
        }
        SSLSocket sslSocket = (SSLSocket)this.getSocket();
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession != null) {
            return sslSession.getProtocol();
        }
        return null;
    }

    @Override
    public int getCipherBits() {
        if (!(this.getSocket() instanceof SSLSocket)) {
            return super.getCipherBits();
        }
        SSLSocket sslSocket = (SSLSocket)this.getSocket();
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession != null) {
            return sslKeySizes.get(sslSession.getCipherSuite());
        }
        return 0;
    }

    @Override
    public X509Certificate getClientCertificate() throws CertificateException {
        X509Certificate[] certs = this.getClientCertificates();
        if (certs == null || certs.length == 0) {
            return null;
        }
        return certs[0];
    }

    @Override
    public X509Certificate[] getClientCertificates() throws CertificateException {
        if (sslSocketClass == null) {
            return null;
        }
        return this.getClientCertificatesImpl();
    }

    private X509Certificate[] getClientCertificatesImpl() throws CertificateException {
        if (!(this.getSocket() instanceof SSLSocket)) {
            return null;
        }
        SSLSocket sslSocket = (SSLSocket)this.getSocket();
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession == null) {
            return null;
        }
        try {
            return (X509Certificate[])sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, e.toString(), e);
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    @Override
    public SelectableChannel getSelectableChannel() {
        return this._channel;
    }

    @Override
    public StreamImpl getStream() throws IOException {
        if (this._streamImpl == null) {
            this._streamImpl = new SocketChannelStream();
        }
        this._streamImpl.init(this._channel);
        return this._streamImpl;
    }

    public void resetTotalBytes() {
    }

    @Override
    public long getTotalReadBytes() {
        return 0L;
    }

    @Override
    public long getTotalWriteBytes() {
        return 0L;
    }

    @Override
    public boolean isClosed() {
        return this._channel == null;
    }

    @Override
    public void close() throws IOException {
        SocketChannel channel = this._channel;
        this._channel = null;
        if (channel != null) {
            try {
                channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._channel + "]";
    }

    static {
        try {
            sslSocketClass = Class.forName("javax.net.ssl.SSLSocket");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sslKeySizes = new IntMap();
        sslKeySizes.put("SSL_DH_anon_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put("SSL_DH_anon_WITH_RC4_128_MD5", 128);
        sslKeySizes.put("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 40);
        sslKeySizes.put("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 40);
        sslKeySizes.put("SSL_DHE_DSS_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 40);
        sslKeySizes.put("SSL_RSA_WITH_RC4_128_MD5", 128);
        sslKeySizes.put("SSL_RSA_WITH_RC4_128_SHA", 128);
        sslKeySizes.put("SSL_RSA_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put("SSL_RSA_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 40);
        sslKeySizes.put("SSL_RSA_WITH_NULL_MD5", 0);
        sslKeySizes.put("SSL_RSA_WITH_NULL_SHA", 0);
        sslKeySizes.put("SSL_DSA_WITH_RC4_128_MD5", 128);
        sslKeySizes.put("SSL_DSA_WITH_RC4_128_SHA", 128);
        sslKeySizes.put("SSL_DSA_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put("SSL_DSA_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put("SSL_DSA_EXPORT_WITH_RC4_40_MD5", 40);
        sslKeySizes.put("SSL_DSA_WITH_NULL_MD5", 0);
        sslKeySizes.put("SSL_DSA_WITH_NULL_SHA", 0);
    }
}

