/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.RandomAccessStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class SpyRandomAccessStream
extends RandomAccessStream {
    private static final Logger log = Logger.getLogger(SpyRandomAccessStream.class.getName());
    private RandomAccessStream _file;

    public SpyRandomAccessStream(RandomAccessStream file) {
        this._file = file;
    }

    @Override
    public long getLength() throws IOException {
        return this._file.getLength();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        log.finest("random-read(0x" + Long.toHexString(this.getFilePointer()) + "," + length + ")");
        return this._file.read(buffer, offset, length);
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        log.finest("random-read(0x" + Long.toHexString(this.getFilePointer()) + "," + length + ")");
        return this._file.read(buffer, offset, length);
    }

    @Override
    public int read(long fileOffset, byte[] buffer, int offset, int length) throws IOException {
        log.info("random-read(0x" + Long.toHexString(fileOffset) + "," + length + ")");
        return this._file.read(fileOffset, buffer, offset, length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        log.info("random-write(0x" + Long.toHexString(this.getFilePointer()) + "," + length + ")");
        this._file.write(buffer, offset, length);
    }

    @Override
    public void write(long fileOffset, byte[] buffer, int offset, int length) throws IOException {
        log.info("random-write(0x" + Long.toHexString(fileOffset) + "," + length + ")");
        this._file.write(fileOffset, buffer, offset, length);
    }

    @Override
    public boolean seek(long position) {
        log.info("random-seek(0x" + position + ")");
        return this._file.seek(position);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._file.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._file.getInputStream();
    }

    @Override
    public int read() throws IOException {
        log.info("random-read(0x" + Long.toHexString(this.getFilePointer()) + ",1)");
        return this._file.read();
    }

    @Override
    public void write(int b) throws IOException {
        log.info("random-write(0x" + Long.toHexString(this.getFilePointer()) + ",1)");
        this._file.write(b);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this._file.getFilePointer();
    }

    @Override
    public void closeImpl() throws IOException {
        this._file.close();
    }
}

