/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;

public class TcpPath
extends Path {
    public static final String CONNECT_TIMEOUT = "connect-timeout";
    private static final long SOCKET_ADDRESS_TIMEOUT = 120000L;
    private String _host;
    private int _port;
    private SocketAddress _address;
    private long _connectTimeout = 5000L;
    private long _socketTimeout = 600000L;
    private boolean _noDelay;
    private long _socketAddressExpireTime = 0L;

    public TcpPath(TcpPath root, String userPath, Map<String, Object> newAttributes, String host, int port) {
        super(root);
        this.setUserPath(userPath);
        this._host = host;
        int n = this._port = port == 0 ? 80 : port;
        if (newAttributes != null) {
            Object socketTimeout;
            Object connTimeout = newAttributes.get(CONNECT_TIMEOUT);
            if (connTimeout instanceof Number) {
                this._connectTimeout = ((Number)connTimeout).longValue();
            }
            if ((socketTimeout = newAttributes.get("socket-timeout")) == null) {
                socketTimeout = newAttributes.get("timeout");
            }
            if (socketTimeout instanceof Number) {
                this._socketTimeout = ((Number)socketTimeout).longValue();
            }
            if (Boolean.TRUE.equals(newAttributes.get("no-delay"))) {
                this._noDelay = true;
            }
        }
    }

    @Override
    public Path schemeWalk(String userPath, Map<String, Object> newAttributes, String uri, int offset) {
        int i;
        int length = uri.length();
        if (length < 2 + offset || uri.charAt(offset) != '/' || uri.charAt(1 + offset) != '/') {
            throw new RuntimeException("bad scheme");
        }
        CharBuffer buf = new CharBuffer();
        char ch = '\u0000';
        boolean isIpv6 = false;
        for (i = 2 + offset; i < length && (ch = uri.charAt(i)) != '/' && ch != '?' && (ch != ':' || isIpv6); ++i) {
            if (ch == '[') {
                isIpv6 = true;
            } else if (ch == ']') {
                isIpv6 = false;
            }
            buf.append(ch);
        }
        String host = buf.toString();
        if (host.length() == 0) {
            throw new RuntimeException("bad host");
        }
        int port = 0;
        if (ch == ':') {
            ++i;
            while (i < length && (ch = uri.charAt(i)) >= '0' && ch <= '9') {
                port = 10 * port + uri.charAt(i) - 48;
                ++i;
            }
        }
        return this.create(this, userPath, newAttributes, host, port);
    }

    protected TcpPath create(TcpPath root, String userPath, Map<String, Object> newAttributes, String host, int port) {
        return new TcpPath(root, userPath, newAttributes, host, port);
    }

    @Override
    public String getScheme() {
        return "tcp";
    }

    @Override
    public String getURL() {
        return this.getScheme() + "://" + this.getHost() + ":" + this.getPort();
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    public SocketAddress getSocketAddress() {
        long now = CurrentTime.getCurrentTime();
        if (this._address == null || this._socketAddressExpireTime < now) {
            this._socketAddressExpireTime = now + 120000L;
            this._address = new InetSocketAddress(this._host, this._port);
        }
        return this._address;
    }

    private void clearSocketAddress() {
        this._socketAddressExpireTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamImpl openReadImpl() throws IOException {
        boolean isValid = false;
        try {
            TcpStream stream = TcpStream.openRead(this, this._connectTimeout, this._socketTimeout, this._noDelay);
            isValid = true;
            TcpStream tcpStream = stream;
            return tcpStream;
        }
        finally {
            if (!isValid) {
                this.clearSocketAddress();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        boolean isValid = false;
        try {
            TcpStream stream = TcpStream.openReadWrite(this, this._connectTimeout, this._socketTimeout, this._noDelay);
            isValid = true;
            TcpStream tcpStream = stream;
            return tcpStream;
        }
        finally {
            if (!isValid) {
                this.clearSocketAddress();
            }
        }
    }

    @Override
    protected Path cacheCopy() {
        return new TcpPath(null, this.getUserPath(), null, this._host, this._port);
    }

    @Override
    public String toString() {
        return this.getURL();
    }
}

