/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempCharBuffer;
import java.io.IOException;

public class TempCharStream
extends StreamImpl {
    private TempCharBuffer _head;
    private TempCharBuffer _tail;

    public void openWrite() {
        TempCharBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempCharBuffer.freeAll(ptr);
    }

    public char[] getTail() {
        return this._tail.getBuffer();
    }

    public TempCharBuffer getHead() {
        return this._head;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public void write(char[] buf, int offset, int length) throws IOException {
        int index = 0;
        while (index < length) {
            if (this._tail == null) {
                this.addBuffer(TempCharBuffer.allocate());
            } else if (this._tail._buf.length <= this._tail._length) {
                this.addBuffer(TempCharBuffer.allocate());
            }
            int sublen = this._tail._buf.length - this._tail._length;
            if (length - index < sublen) {
                sublen = length - index;
            }
            System.arraycopy(buf, index + offset, this._tail._buf, this._tail._length, sublen);
            index += sublen;
            this._tail._length += sublen;
        }
    }

    public void write(String s, int offset, int length) throws IOException {
        while (length > 0) {
            if (this._tail == null) {
                this.addBuffer(TempCharBuffer.allocate());
            } else if (this._tail._buf.length <= this._tail._length) {
                this.addBuffer(TempCharBuffer.allocate());
            }
            int sublen = this._tail._buf.length - this._tail._length;
            if (length < sublen) {
                sublen = length;
            }
            s.getChars(offset, offset + sublen, this._tail._buf, this._tail._length);
            offset += sublen;
            length -= sublen;
            this._tail._length += sublen;
        }
    }

    public void write(int ch) throws IOException {
        if (this._tail == null) {
            this.addBuffer(TempCharBuffer.allocate());
        } else if (this._tail._buf.length <= this._tail._length) {
            this.addBuffer(TempCharBuffer.allocate());
        }
        this._tail._buf[this._tail._length++] = (char)ch;
    }

    private void addBuffer(TempCharBuffer buf) {
        buf._next = null;
        if (this._tail != null) {
            this._tail._next = buf;
            this._tail = buf;
        } else {
            this._tail = buf;
            this._head = buf;
        }
        ++this._head._bufferCount;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public int getLength() {
        int length = 0;
        TempCharBuffer ptr = this._head;
        while (ptr != null) {
            length += ptr.getLength();
            ptr = ptr._next;
        }
        return length;
    }

    @Override
    public void clearWrite() {
        TempCharBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempCharBuffer.freeAll(ptr);
    }

    public void discard() {
        this._head = null;
        this._tail = null;
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TempCharBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempCharBuffer.freeAll(ptr);
    }
}

