/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ByteToCharWriter;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriterStreamImpl
extends StreamImpl {
    private static Logger log = Logger.getLogger(WriterStreamImpl.class.getName());
    private Writer _writer;
    private ByteToCharWriter _byteToChar = new ByteToCharWriter();
    private boolean _isClosed;

    public void setWriter(Writer writer) {
        this._writer = writer;
        this._byteToChar.setWriter(writer);
        this._isClosed = false;
        try {
            this._byteToChar.setEncoding(null);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void setWriteEncoding(String encoding) {
        try {
            this._byteToChar.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        if (this._isClosed) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this._byteToChar.addByte(buffer[offset + i]);
        }
        this._byteToChar.flush();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        this._isClosed = true;
    }
}

