/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.xml.stream.NamespaceReaderContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXSourceXMLEventReaderImpl
implements XMLEventReader {
    private static final Logger log = Logger.getLogger(SAXSourceXMLEventReaderImpl.class.getName());
    private static final L10N L = new L10N(SAXSourceXMLEventReaderImpl.class);
    private static final XMLEventFactory EVENT_FACTORY = XMLEventFactory.newInstance();
    private static SAXParserFactory _saxParserFactory;
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String PREFIX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private final ArrayList<XMLEvent> _events = new ArrayList();
    private final EventGeneratingContentHandler _contentHandler;

    public static SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXException {
        if (_saxParserFactory == null) {
            _saxParserFactory = SAXParserFactory.newInstance();
            _saxParserFactory.setFeature(NAMESPACE_FEATURE, true);
            _saxParserFactory.setFeature(PREFIX_FEATURE, true);
            _saxParserFactory.setNamespaceAware(true);
        }
        return _saxParserFactory;
    }

    public SAXSourceXMLEventReaderImpl(SAXSource source) throws XMLStreamException {
        XMLReader reader = source.getXMLReader();
        if (reader == null) {
            try {
                reader = XMLReaderFactory.createXMLReader();
                source.setXMLReader(reader);
            }
            catch (SAXException e) {
                throw new XMLStreamException(e);
            }
        }
        this._contentHandler = new EventGeneratingContentHandler();
        reader.setContentHandler(this._contentHandler);
        try {
            reader.parse(source.getInputSource());
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public SAXSourceXMLEventReaderImpl() {
        this._contentHandler = new EventGeneratingContentHandler();
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getElementText() throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        XMLEvent event = null;
        event = this.peek();
        while (!event.isEndElement()) {
            if (!event.isCharacters()) {
                throw new XMLStreamException("Unexpected event: " + event);
            }
            event = this.nextEvent();
            sb.append(((Characters)event).getData());
            event = this.peek();
        }
        return sb.toString();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    @Override
    public boolean hasNext() {
        return this._events.size() > 0;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        try {
            return this._events.remove(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent event = null;
        event = this.nextEvent();
        while (!event.isStartElement() && !event.isEndElement()) {
            if (event.getEventType() != 6) {
                throw new XMLStreamException("Unexpected event: " + event);
            }
            event = this.nextEvent();
        }
        return event;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        try {
            return this._events.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLEvent next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    private class EventGeneratingContentHandler
    implements ContentHandler {
        private NamespaceReaderContext _context = new NamespaceReaderContext();
        private ArrayList<Namespace> _newMappings = new ArrayList();
        private ArrayList<Namespace> _oldMappings = new ArrayList();
        private QName _pendingEndName = null;

        private EventGeneratingContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.checkForPendingEndElement();
            String s = new String(ch, start, length);
            SAXSourceXMLEventReaderImpl.this._events.add(EVENT_FACTORY.createCharacters(s));
        }

        @Override
        public void endDocument() throws SAXException {
            this.checkForPendingEndElement();
            SAXSourceXMLEventReaderImpl.this._events.add(EVENT_FACTORY.createEndDocument());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            int colon = qName.indexOf(58);
            if (colon < 0) {
                this._pendingEndName = uri == null || "".equals(uri) ? new QName(localName) : new QName(uri, localName);
            } else {
                String prefix = qName.substring(0, colon);
                this._pendingEndName = new QName(uri, localName, prefix);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            String uri = this._context.getUri(prefix);
            if (uri == null) {
                throw new SAXException("Unknown prefix: " + prefix);
            }
            this._oldMappings.add(EVENT_FACTORY.createNamespace(prefix, uri));
        }

        private void checkForPendingEndElement() throws SAXException {
            if (this._pendingEndName != null) {
                Iterator<Namespace> iterator = this._oldMappings.iterator();
                SAXSourceXMLEventReaderImpl.this._events.add(EVENT_FACTORY.createEndElement(this._pendingEndName, iterator));
                this._pendingEndName = null;
                this._oldMappings = new ArrayList();
                try {
                    this._context.pop();
                }
                catch (XMLStreamException e) {
                    throw new SAXException(e);
                }
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.checkForPendingEndElement();
            String s = new String(ch, start, length);
            SAXSourceXMLEventReaderImpl.this._events.add(EVENT_FACTORY.createIgnorableSpace(s));
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.checkForPendingEndElement();
            SAXSourceXMLEventReaderImpl.this._events.add(EVENT_FACTORY.createProcessingInstruction(target, data));
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void startDocument() {
            SAXSourceXMLEventReaderImpl.this._events.add(EVENT_FACTORY.createStartDocument());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.checkForPendingEndElement();
            this._context.push();
            Iterator attributeIterator = null;
            Iterator namespaceIterator = null;
            if (atts.getLength() > 0) {
                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
                namespaces.addAll(this._newMappings);
                this._newMappings.clear();
                for (int i = 0; i < atts.getLength(); ++i) {
                    Attribute attribute = null;
                    Namespace namespace = null;
                    String qualified = atts.getQName(i);
                    String local = atts.getLocalName(i);
                    String namespaceURI = atts.getURI(i);
                    String value = atts.getValue(i);
                    int colon = qualified.indexOf(58);
                    if (colon < 0) {
                        if (namespaceURI == null || "".equals(namespaceURI)) {
                            attribute = EVENT_FACTORY.createAttribute(local, value);
                        } else if ("xmlns".equals(local)) {
                            namespace = EVENT_FACTORY.createNamespace(value);
                        } else {
                            QName name = new QName(namespaceURI, local);
                            attribute = EVENT_FACTORY.createAttribute(name, value);
                        }
                    } else {
                        String prefix = qualified.substring(0, colon);
                        if ("xmlns".equals(prefix)) {
                            namespace = EVENT_FACTORY.createNamespace(local, value);
                        } else {
                            attribute = EVENT_FACTORY.createAttribute(prefix, namespaceURI, local, value);
                        }
                    }
                    if (attribute != null) {
                        attributes.add(attribute);
                    }
                    if (namespace == null) continue;
                    this._context.declare(namespace.getPrefix(), namespace.getNamespaceURI());
                    namespaces.add(namespace);
                }
                attributeIterator = attributes.iterator();
                namespaceIterator = namespaces.iterator();
            }
            QName name = null;
            int colon = qName.indexOf(58);
            if (colon < 0) {
                if (localName == null) {
                    localName = qName;
                }
                name = uri == null || "".equals(uri) ? new QName(localName) : new QName(uri, localName);
            } else {
                String prefix = qName.substring(0, colon);
                name = new QName(uri, localName, prefix);
            }
            StartElement start = EVENT_FACTORY.createStartElement(name, attributeIterator, namespaceIterator);
            SAXSourceXMLEventReaderImpl.this._events.add(start);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.checkForPendingEndElement();
            this._newMappings.add(EVENT_FACTORY.createNamespace(prefix, uri));
            this._context.declare(prefix, uri);
        }
    }
}

