/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.xml.stream.DOMSourceXMLStreamReaderImpl;
import com.caucho.xml.stream.FilteredEventReader;
import com.caucho.xml.stream.FilteredStreamReader;
import com.caucho.xml.stream.JAXPNotSupportedInStAXException;
import com.caucho.xml.stream.SAXSourceXMLEventReaderImpl;
import com.caucho.xml.stream.XMLEventAllocatorImpl;
import com.caucho.xml.stream.XMLEventReaderImpl;
import com.caucho.xml.stream.XMLStreamReaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

public class XMLInputFactoryImpl
extends XMLInputFactory {
    private XMLEventAllocator _allocator = new XMLEventAllocatorImpl();
    private XMLReporter _reporter;
    private XMLResolver _resolver;

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return new FilteredEventReader(reader, filter);
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return new FilteredStreamReader(reader, filter);
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream) throws XMLStreamException {
        return new XMLEventReaderImpl(this.getEventAllocator(), this.createXMLStreamReader(stream));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream, String encoding) throws XMLStreamException {
        return new XMLEventReaderImpl(this.getEventAllocator(), this.createXMLStreamReader(stream, encoding));
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return new XMLEventReaderImpl(this.getEventAllocator(), this.createXMLStreamReader(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        if (source instanceof SAXSource) {
            return new SAXSourceXMLEventReaderImpl((SAXSource)source);
        }
        return new XMLEventReaderImpl(this.getEventAllocator(), this.createXMLStreamReader(source));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, InputStream stream) throws XMLStreamException {
        return new XMLEventReaderImpl(this.getEventAllocator(), this.createXMLStreamReader(systemId, stream));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        return new XMLEventReaderImpl(this.getEventAllocator(), this.createXMLStreamReader(systemId, reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        return new XMLEventReaderImpl(this.getEventAllocator(), reader);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        return new XMLStreamReaderImpl(stream);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        if (encoding == null) {
            encoding = "iso-8859-1";
        }
        try {
            InputStreamReader isr = new InputStreamReader(stream, encoding);
            return new XMLStreamReaderImpl(isr);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return new XMLStreamReaderImpl(reader);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream is = streamSource.getInputStream();
            if (is != null) {
                return new XMLStreamReaderImpl(is);
            }
            Reader r = streamSource.getReader();
            if (r != null) {
                return new XMLStreamReaderImpl(r);
            }
            if (streamSource.getSystemId() != null) {
                try {
                    URL url = new URL(streamSource.getSystemId());
                    return new XMLStreamReaderImpl(url.openStream());
                }
                catch (MalformedURLException e) {
                    throw new XMLStreamException(e);
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
            }
            throw new XMLStreamException("StreamSource contains no stream information");
        }
        if (source instanceof DOMSource) {
            return new DOMSourceXMLStreamReaderImpl((DOMSource)source);
        }
        if (source instanceof SAXSource) {
            throw new JAXPNotSupportedInStAXException();
        }
        throw new JAXPNotSupportedInStAXException();
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        return new XMLStreamReaderImpl(stream, systemId);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return new XMLStreamReaderImpl(reader, systemId);
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this._allocator;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("property \"" + name + "\" not supported");
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this._reporter;
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this._resolver;
    }

    @Override
    public boolean isPropertySupported(String name) {
        return false;
    }

    @Override
    public void setEventAllocator(XMLEventAllocator allocator) {
        this._allocator = allocator;
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if ("javax.xml.stream.allocator".equals(name)) {
            this.setEventAllocator((XMLEventAllocator)value);
            return;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            return;
        }
        if ("javax.xml.stream.supportDTD".equals(name)) {
            boolean supportDTD = (Boolean)value;
            if (supportDTD) {
                throw new UnsupportedOperationException("javax.xml.stream.supportDTD=true not implemented");
            }
            return;
        }
        throw new IllegalArgumentException("property \"" + name + "\" not supported");
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
        this._reporter = reporter;
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
        this._resolver = resolver;
    }
}

