/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.SelectedNode;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class MergeIterator
extends NodeIterator {
    private NodeIterator _baseIterator;
    private SelectedNode[] _nodes = new SelectedNode[32];
    private int _head;
    private int _tail;

    public MergeIterator(ExprEnvironment env, NodeIterator baseIterator) throws XPathException {
        super(env);
        SelectedNode node;
        this._baseIterator = baseIterator;
        block0: while ((node = baseIterator.nextSelectedNode()) != null) {
            int ptr;
            SelectedNode oldNode;
            int cmp;
            int index;
            if (this._tail == this._nodes.length) {
                SelectedNode[] newNodes = new SelectedNode[2 * this._nodes.length];
                System.arraycopy(this._nodes, 0, newNodes, 0, this._nodes.length);
                this._nodes = newNodes;
            }
            for (index = this._tail; index > 0 && (cmp = node.compareTo(oldNode = this._nodes[index - 1])) <= 0; --index) {
                if (cmp == 0) continue block0;
            }
            ++this._tail;
            while (index < ptr) {
                this._nodes[ptr] = this._nodes[ptr - 1];
                --ptr;
            }
            this._nodes[index] = node;
        }
    }

    @Override
    public boolean hasNext() {
        return this._head < this._tail;
    }

    @Override
    public Node nextNode() {
        if (this._head < this._tail) {
            this._position = this._head + 1;
            return this._nodes[this._head++].getNode();
        }
        return null;
    }

    @Override
    public SelectedNode nextSelectedNode() {
        if (this._head < this._tail) {
            this._position = this._head + 1;
            return this._nodes[this._head++];
        }
        return null;
    }

    @Override
    public Object clone() {
        try {
            MergeIterator clone = new MergeIterator(this._env, this._baseIterator);
            clone._head = this._head;
            clone._tail = this._tail;
            if (this._nodes.length != clone._nodes.length) {
                clone._nodes = new SelectedNode[this._nodes.length];
            }
            System.arraycopy(this._nodes, 0, clone._nodes, 0, this._tail);
            return clone;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }
}

