/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xpath.Expr;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;

public class XslNumber
extends XslNode {
    private String _value;
    private String _count;
    private String _from;
    private String _level = "single";
    private String _format;
    private String _letter;
    private String _lang;
    private String _groupingSeparator;
    private String _groupingSize = "";

    @Override
    public String getTagName() {
        return "xsl:number";
    }

    @Override
    public void addAttribute(QName name, String value) throws XslParseException {
        if ("value".equals(name.getName())) {
            this._value = value;
        } else if ("count".equals(name.getName())) {
            this._count = value;
        } else if ("from".equals(name.getName())) {
            this._from = value;
        } else if ("level".equals(name.getName())) {
            this._level = value;
        } else if ("format".equals(name.getName())) {
            this._format = value;
        } else if ("letter-value".equals(name.getName())) {
            this._letter = value;
        } else if ("lang".equals(name.getName())) {
            this._lang = value;
        } else if ("grouping-separator".equals(name.getName())) {
            this._groupingSeparator = value;
        } else if ("grouping-size".equals(name.getName())) {
            this._groupingSize = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    @Override
    public void endAttributes() throws XslParseException {
    }

    @Override
    public void generate(JavaWriter out) throws Exception {
        int size = 0;
        for (int i = 0; i < this._groupingSize.length(); ++i) {
            char ch = this._groupingSize.charAt(i);
            if (ch < '0' || ch > '9') continue;
            size = 10 * size + ch - 48;
        }
        boolean isAlphabetic = true;
        if (!"alphabetic".equals(this._letter)) {
            isAlphabetic = false;
        }
        AbstractPattern countPattern = null;
        if (this._count != null) {
            countPattern = this.parseMatch(this._count);
        }
        AbstractPattern fromPattern = null;
        if (this._from != null) {
            fromPattern = this.parseMatch(this._from);
        }
        if (this._level == null || this._level.equals("single")) {
            this._level = "single";
        } else if (!this._level.equals("multiple") && !this._level.equals("any")) {
            throw this.error(L.l("xsl:number can't understand level=`{0}'", (Object)this._level));
        }
        XslNumberFormat xslFormat = new XslNumberFormat(this._format, this._lang, isAlphabetic, this._groupingSeparator, size);
        if (this._value != null) {
            this.printNumber(out, this.parseExpr(this._value), xslFormat);
        } else {
            this.printNumber(out, this._level, countPattern, fromPattern, xslFormat);
        }
    }

    void printNumber(JavaWriter out, Expr expr, XslNumberFormat format) throws Exception {
        int index = this._gen.addExpr(expr);
        out.print("exprNumber(out, node, env, _exprs[" + index + "]");
        out.print(", _xsl_formats[" + this._gen.addFormat(format) + "]");
        out.println(");");
    }

    void printNumber(JavaWriter out, String level, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
        if (level.equals("single")) {
            out.print("singleNumber(out, ");
        } else if (level.equals("multiple")) {
            out.print("multiNumber(out, ");
        } else if (level.equals("any")) {
            out.print("anyNumber(out, ");
        } else {
            throw this.error(L.l("xsl:number cannot understand level='{0}'", (Object)level));
        }
        out.print("node, env, ");
        this.printPattern(out, countPattern);
        out.print(", ");
        this.printPattern(out, fromPattern);
        out.print(", _xsl_formats[" + this._gen.addFormat(format) + "]");
        out.println(");");
    }

    void printPattern(JavaWriter out, AbstractPattern pattern) throws Exception {
        if (pattern == null) {
            out.print("null");
        } else {
            out.print("_match_patterns[" + this._gen.addMatch(pattern) + "]");
        }
    }
}

