/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslTopNode;

public class XslTemplate
extends XslNode
implements XslTopNode {
    private String _match;
    private String _name;
    private String _mode;
    private double _priority = Double.NaN;
    private String _as;
    private String _macroName;

    @Override
    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("match")) {
            this._match = value;
        } else if (name.getName().equals("name")) {
            this._name = value;
        } else if (name.getName().equals("mode")) {
            this._mode = value;
        } else if (name.getName().equals("priority")) {
            this._priority = Double.parseDouble(value);
        } else if (name.getName().equals("as")) {
            this._as = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    @Override
    public void endAttributes() throws XslParseException {
        if (this._match == null && this._name == null) {
            throw this.error(L.l("xsl:template needs a 'match' or a 'name' attribute."));
        }
        if (this._name != null) {
            this._macroName = "_xsl_macro_" + this._gen.toJavaIdentifier(this._name) + "__" + this._gen.uniqueId();
            this._gen.addMacro(this._name, this._macroName);
        }
    }

    @Override
    public void generate(JavaWriter out) throws Exception {
        String fun = null;
        if (this._match != null) {
            fun = this._gen.createTemplatePattern(this._name, this.parseMatch(this._match), this._mode, this._priority);
            out.println();
            out.print("// '" + this._match.replace('\n', ' ') + "'");
            if (this._mode != null) {
                this._gen.addMode(this._mode);
                out.println(" mode '" + this._mode + "'");
            } else {
                out.println();
            }
            out.printJavaString("// " + this.getFilename() + ":" + this.getStartLine());
            out.println();
            out.println("private void " + fun + "(XslWriter out, Node inputNode, Env env)");
            out.println("  throws Exception");
            out.println("{");
            out.pushDepth();
            out.println("Object _xsl_tmp;");
            out.println("Node node = inputNode;");
            out.println("int _xsl_top = env.getTop();");
            boolean isRawText = this._gen.getDisableOutputEscaping();
            if (isRawText) {
                out.println("boolean oldEscaping = out.disableEscaping(true);");
            } else {
                out.println("boolean oldEscaping = out.disableEscaping(false);");
            }
            String filename = this.getBaseURI();
            if (filename != null) {
                int pos = this._gen.addStylesheet(filename);
                out.println("env.setStylesheetEnv(stylesheets[" + pos + "]);");
            }
            this._gen.setSelectDepth(0);
            this._gen.clearUnique();
            this.generateChildren(out);
            out.println("out.disableEscaping(oldEscaping);");
            out.println("env.popToTop(_xsl_top);");
            out.popDepth();
            out.println("}");
            out.println();
        }
        if (this._name != null) {
            out.println("void " + this._macroName + "(XslWriter out, Node inputNode, Env env)");
            out.println("  throws Exception");
            out.println("{");
            out.pushDepth();
            if (this._match == null) {
                out.println("Object _xsl_tmp;");
                out.println("Node node = inputNode;");
                this.generateChildren(out);
            } else {
                out.println(fun + "(out, inputNode, env);");
            }
            out.popDepth();
            out.println("}");
        }
    }
}

