/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j.analysis;

import com.chenlb.mmseg4j.MMSeg;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.Word;
import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class MMSegTokenizer
extends Tokenizer {
    private MMSeg mmSeg;
    private CharTermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private final Seg seg;

    public MMSegTokenizer(Seg seg) {
        this.seg = seg;
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public void reset() throws IOException {
        super.reset();
        if (this.mmSeg == null) {
            this.mmSeg = new MMSeg(this.input, this.seg);
        } else {
            this.mmSeg.reset(this.input);
        }
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        Word word = this.mmSeg.next();
        if (word != null) {
            this.termAtt.copyBuffer(word.getSen(), word.getWordOffset(), word.getLength());
            this.offsetAtt.setOffset(word.getStartOffset(), word.getEndOffset());
            this.typeAtt.setType(word.getType());
            return true;
        }
        return false;
    }
}

