/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j.solr;

import com.chenlb.mmseg4j.ComplexSeg;
import com.chenlb.mmseg4j.Dictionary;
import com.chenlb.mmseg4j.MaxWordSeg;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.SimpleSeg;
import com.chenlb.mmseg4j.analysis.MMSegTokenizer;
import com.chenlb.mmseg4j.solr.Utils;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMSegTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(MMSegTokenizerFactory.class);
    private ThreadLocal<MMSegTokenizer> tokenizerLocal = new ThreadLocal();
    protected Dictionary dic = null;

    public MMSegTokenizerFactory(Map<String, String> args) {
        super(args);
    }

    private Seg newSeg(Map<String, String> args) {
        SimpleSeg seg = null;
        logger.info("create new Seg ...");
        String mode = args.get("mode");
        if ("simple".equals(mode)) {
            logger.info("use simple mode");
            seg = new SimpleSeg(this.dic);
        } else if ("complex".equals(mode)) {
            logger.info("use complex mode");
            seg = new ComplexSeg(this.dic);
        } else {
            logger.info("use max-word mode");
            seg = new MaxWordSeg(this.dic);
        }
        return seg;
    }

    public Tokenizer create(AttributeFactory factory) {
        MMSegTokenizer tokenizer = this.tokenizerLocal.get();
        if (tokenizer == null) {
            tokenizer = this.newTokenizer();
        }
        return tokenizer;
    }

    private MMSegTokenizer newTokenizer() {
        MMSegTokenizer tokenizer = new MMSegTokenizer(this.newSeg(this.getOriginalArgs()));
        this.tokenizerLocal.set(tokenizer);
        return tokenizer;
    }

    public void inform(ResourceLoader loader) {
        String dicPath = (String)this.getOriginalArgs().get("dicPath");
        this.dic = Utils.getDict(dicPath, loader);
        logger.info("dic load... in={}", (Object)this.dic.getDicPath().toURI());
    }
}

