/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public abstract class ClickHouseObjectValue<T>
implements ClickHouseValue {
    private T value;

    protected ClickHouseObjectValue(T value) {
        this.set(value);
    }

    protected ClickHouseObjectValue<T> set(T value) {
        this.value = value;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.value == null;
    }

    @Override
    public byte asByte() {
        if (this.isNullOrEmpty()) {
            return 0;
        }
        throw this.newUnsupportedException("Object", "byte");
    }

    @Override
    public short asShort() {
        if (this.isNullOrEmpty()) {
            return 0;
        }
        throw this.newUnsupportedException("Object", "short");
    }

    @Override
    public int asInteger() {
        if (this.isNullOrEmpty()) {
            return 0;
        }
        throw this.newUnsupportedException("Object", "int");
    }

    @Override
    public long asLong() {
        if (this.isNullOrEmpty()) {
            return 0L;
        }
        throw this.newUnsupportedException("Object", "long");
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        throw this.newUnsupportedException("Object", "BigInteger");
    }

    @Override
    public float asFloat() {
        if (this.isNullOrEmpty()) {
            return 0.0f;
        }
        throw this.newUnsupportedException("Object", "float");
    }

    @Override
    public double asDouble() {
        if (this.isNullOrEmpty()) {
            return 0.0;
        }
        throw this.newUnsupportedException("Object", "double");
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        throw this.newUnsupportedException("Object", "BigDecimal");
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        String str = this.value.toString();
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseObjectValue<T> resetToNullOrEmpty() {
        return this.set(null);
    }

    @Override
    public String toSqlExpression() {
        return this.isNullOrEmpty() ? "NULL" : this.asString();
    }

    @Override
    public ClickHouseValue update(Object value) {
        return ClickHouseValue.super.update(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseObjectValue v = (ClickHouseObjectValue)obj;
        return this.value == v.value || this.value != null && this.value.equals(v.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

