/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.logging;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.logging.JdkLoggerFactory;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.Slf4jLoggerFactory;

public abstract class LoggerFactory {
    private static final LoggerFactory instance = ClickHouseUtils.getService(LoggerFactory.class, () -> {
        LoggerFactory factory = null;
        try {
            if (org.slf4j.LoggerFactory.getILoggerFactory() != null) {
                factory = new Slf4jLoggerFactory();
            }
        }
        catch (Throwable ignore) {
            factory = new JdkLoggerFactory();
        }
        return ClickHouseChecker.nonNull(factory, "factory");
    });

    public static Logger getLogger(Class<?> clazz) {
        return instance.get(clazz);
    }

    public static Logger getLogger(String name) {
        return instance.get(name);
    }

    public static LoggerFactory getInstance() {
        return instance;
    }

    public Logger get(Class<?> clazz) {
        return this.get(ClickHouseChecker.nonNull(clazz, "Class").getName());
    }

    public abstract Logger get(String var1);
}

