/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc.config;

import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import java.io.Serializable;

public enum ClickHouseGrpcOption implements ClickHouseOption
{
    FLOW_CONTROL_WINDOW("flow_control_window", 0, "Size of flow control window in byte, 0 or negative number are same as default."),
    MAX_INBOUND_MESSAGE_SIZE("max_inbound_message_size", 0x800000, "The maximum message size allowed to be received."),
    MAX_INBOUND_METADATA_SIZE("max_inbound_metadata_size", 8192, "The maximum size of metadata allowed to be received. This enforces HTTP/2 SETTINGS_MAX_HEADER_LIST_SIZE, the maximum size of header list that client is prepared to accept."),
    USE_OKHTTP("use_okhttp", false, "Whether to use lightweight transport based on Okhttp instead of Netty. In most cases Netty is faster than Okhttp."),
    USE_FULL_STREAM_DECOMPRESSION("use_full_stream_decompression", false, "Whether to use full stream decompression for better compression ratio or not.");

    private final String key;
    private final Serializable defaultValue;
    private final Class<? extends Serializable> clazz;
    private final String description;

    private <T extends Serializable> ClickHouseGrpcOption(String key, T defaultValue, String description) {
        this.key = (String)ClickHouseChecker.nonNull((Object)key, (String)"key");
        this.defaultValue = (Serializable)ClickHouseChecker.nonNull(defaultValue, (String)"defaultValue");
        this.clazz = defaultValue.getClass();
        this.description = (String)ClickHouseChecker.nonNull((Object)description, (String)"description");
    }

    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKey() {
        return this.key;
    }

    public Class<? extends Serializable> getValueType() {
        return this.clazz;
    }
}

