/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk;

import com.cmbchina.ccd.cmblife.sdk.cipher.AesUtils;
import com.cmbchina.ccd.cmblife.sdk.cipher.RsaUtils;
import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import com.cmbchina.ccd.cmblife.sdk.global.JsonUtils;
import com.cmbchina.ccd.cmblife.sdk.global.StringUtils;
import com.cmbchina.ccd.cmblife.sdk.global.URLUtils;
import java.security.GeneralSecurityException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class CmblifeUtils {
    public static String genProtocol(String funcName, Map<String, Object> paramsMap, String signKey, String signAlgorithm) throws GeneralSecurityException {
        if (StringUtils.isBlank(signKey)) {
            throw new IllegalArgumentException("signKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(funcName)) {
            throw new IllegalArgumentException("funcName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(signAlgorithm)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.putAll(paramsMap);
        String unsignedProtocol = URLUtils.assembleProtocol(funcName, tempMap, false);
        String sign = CmblifeUtils.sign(unsignedProtocol, signKey, signAlgorithm);
        tempMap.put("sign", sign);
        return URLUtils.assembleProtocol(funcName, tempMap, true);
    }

    public static String genProtocol(String funcName, Map<String, Object> paramsMap, String signKey) throws GeneralSecurityException {
        return CmblifeUtils.genProtocol(funcName, paramsMap, signKey, "SHA256WithRSA");
    }

    public static String encrypt(String encryptBody, String encryptKey) throws GeneralSecurityException {
        if (StringUtils.isBlank(encryptBody)) {
            throw new IllegalArgumentException("\u62a5\u6587\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(encryptKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        byte[] aesKey = AesUtils.genAesKey();
        byte[] aesEncryptedBody = AesUtils.encrypt(encryptBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), aesKey);
        byte[] encryptedAesKey = RsaUtils.encrypt(aesKey, StringUtils.base64Decode(encryptKey));
        return String.valueOf(StringUtils.newStringUtf8(StringUtils.base64Encode(encryptedAesKey))) + "|" + StringUtils.newStringUtf8(StringUtils.base64Encode(aesEncryptedBody));
    }

    public static String decrypt(String decryptBody, String decryptKey) throws GeneralSecurityException {
        String[] data = decryptBody.split("\\|");
        if (2 != data.length) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u62a5\u6587\u683c\u5f0f\u9519\u8bef!");
        }
        byte[] aesKey = RsaUtils.decrypt(StringUtils.base64Decode(data[0]), StringUtils.base64Decode(decryptKey));
        byte[] body = AesUtils.decrypt(StringUtils.base64Decode(data[1]), aesKey);
        return new String(body, Constants.DEFAULT_CHARSET_ENCODING);
    }

    private static String sign(String signBody, String signKey, String signAlgorithm) throws GeneralSecurityException {
        if (StringUtils.isBlank(signBody)) {
            throw new IllegalArgumentException("\u5f85\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(signKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(signAlgorithm)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return RsaUtils.sign(signBody, signKey, signAlgorithm);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("\u5bc6\u94a5\u683c\u5f0f\u4e0d\u5bf9!" + e.getMessage());
        }
    }

    private static boolean verify(String verifyBody, String sign, String verifyKey, String verifyAlgorithm) throws GeneralSecurityException {
        if (StringUtils.isBlank(verifyBody)) {
            throw new IllegalArgumentException("\u9a8c\u7b7e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(sign)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(verifyKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(verifyAlgorithm)) {
            throw new IllegalArgumentException("\u9a8c\u7b7e\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return RsaUtils.verify(verifyBody, verifyKey, sign, verifyAlgorithm);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("\u5bc6\u94a5\u683c\u5f0f\u4e0d\u5bf9!" + e.getMessage());
        }
        catch (SignatureException e) {
            throw new SignatureException("\u7b7e\u540d\u683c\u5f0f\u4e0d\u5bf9" + e.getMessage());
        }
    }

    public static String signForRequest(String funcName, Map<String, Object> params, String signKey, String signAlgorithm) throws GeneralSecurityException {
        return CmblifeUtils.sign(URLUtils.assembleUrl(String.valueOf(funcName) + ".json", params, false), signKey, signAlgorithm);
    }

    public static String signForRequest(String funcName, Map<String, Object> params, String signKey) throws GeneralSecurityException {
        return CmblifeUtils.signForRequest(funcName, params, signKey, "SHA256WithRSA");
    }

    public static String signForResponse(Map<String, Object> params, String signKey, String signAlgorithm) throws GeneralSecurityException {
        return CmblifeUtils.sign(URLUtils.assembleUrl("", params, false), signKey, signAlgorithm);
    }

    public static String signForResponse(Map<String, Object> params, String signKey) throws GeneralSecurityException {
        return CmblifeUtils.signForResponse(params, signKey, "SHA256WithRSA");
    }

    public static boolean verifyForRequest(Map<String, Object> params, String verifyKey, String verifyAlgorithm) throws GeneralSecurityException {
        HashMap<String, Object> verifySignParams = new HashMap<String, Object>(params);
        String sign = (String)verifySignParams.remove("sign");
        return CmblifeUtils.verify(URLUtils.assembleUrl("", verifySignParams, false), sign, verifyKey, verifyAlgorithm);
    }

    public static boolean verifyForRequest(Map<String, Object> params, String verifyKey) throws GeneralSecurityException {
        return CmblifeUtils.verifyForRequest(params, verifyKey, "SHA256WithRSA");
    }

    public static boolean verifyForResponse(String response, String verifyKey, String verifyAlgorithm) throws GeneralSecurityException {
        Map<String, Object> verifySignParams = JsonUtils.jsonToMap(response);
        String sign = (String)verifySignParams.remove("sign");
        return CmblifeUtils.verify(URLUtils.assembleUrl("", verifySignParams, false), sign, verifyKey, verifyAlgorithm);
    }

    public static boolean verifyForResponse(String response, String verifyKey) throws GeneralSecurityException {
        return CmblifeUtils.verifyForResponse(response, verifyKey, "SHA256WithRSA");
    }

    public static String genRequestBody(Map<String, Object> params) {
        return URLUtils.assembleUrl(null, params, true);
    }

    public static String genDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return sdf.format(date);
    }

    public static String genRandom() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static Map<String, Object> jsonToMap(String json) {
        return JsonUtils.jsonToMap(json);
    }

    public static String mapToJson(Map<String, Object> params) {
        return JsonUtils.mapToJson(params);
    }
}

