/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk.global;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsonUtils {
    public static Map<String, Object> jsonToMap(String json) {
        return JsonUtils.jsonObjectToMap(JsonUtils.stringToJsonObject(json));
    }

    private static JsonObject stringToJsonObject(String string) {
        return new JsonParser().parse(string).getAsJsonObject();
    }

    public static String mapToJson(Map<String, Object> params) {
        return JsonUtils.objectToJson(params);
    }

    public static String objectToJson(Object object) {
        Gson gson = new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
        return gson.toJson(object);
    }

    private static Map<String, Object> jsonObjectToMap(JsonObject json) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Set entrySet = json.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JsonPrimitive) {
                String tmpValue = value.toString();
                if (((JsonPrimitive)value).isString()) {
                    map.put(key, ((JsonPrimitive)value).getAsString());
                    continue;
                }
                if (((JsonPrimitive)value).isBoolean()) {
                    map.put(key, ((JsonPrimitive)value).getAsBoolean());
                    continue;
                }
                if (tmpValue.contains(".")) {
                    map.put(key, ((JsonPrimitive)value).getAsDouble());
                    continue;
                }
                map.put(key, ((JsonPrimitive)value).getAsLong());
                continue;
            }
            if (value instanceof JsonArray) {
                map.put(key, JsonUtils.jsonArrayToList((JsonArray)value));
                continue;
            }
            if (value instanceof JsonObject) {
                map.put(key, JsonUtils.jsonObjectToMap((JsonObject)value));
                continue;
            }
            if (value instanceof JsonNull) {
                map.put(key, null);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> jsonArrayToList(JsonArray json) {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = json.size();
        int i = 0;
        while (i < size) {
            JsonElement value = json.get(i);
            if (value instanceof JsonPrimitive) {
                String tmpValue = value.toString();
                if (((JsonPrimitive)value).isString()) {
                    list.add(((JsonPrimitive)value).getAsString());
                } else if (((JsonPrimitive)value).isBoolean()) {
                    list.add(((JsonPrimitive)value).getAsBoolean());
                } else if (tmpValue.contains(".")) {
                    list.add(((JsonPrimitive)value).getAsDouble());
                } else {
                    list.add(((JsonPrimitive)value).getAsLong());
                }
            } else if (value instanceof JsonArray) {
                list.add(JsonUtils.jsonArrayToList((JsonArray)value));
            } else if (value instanceof JsonObject) {
                list.add(JsonUtils.jsonObjectToMap((JsonObject)value));
            } else if (value instanceof JsonNull) {
                list.add(null);
            } else {
                list.add(value);
            }
            ++i;
        }
        return list;
    }
}

