/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk.global;

import com.cmbchina.ccd.cmblife.sdk.global.JsonUtils;
import com.cmbchina.ccd.cmblife.sdk.global.StringUtils;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public final class URLUtils {
    public static String assembleUrl(String prefix, String queryString) {
        if (StringUtils.isBlank(prefix)) {
            return queryString;
        }
        return String.valueOf(prefix) + (prefix.contains("?") ? "&" : "?") + queryString;
    }

    public static String assembleUrl(String prefix, Map<String, Object> paramsMap, boolean isUrlEncode) {
        return URLUtils.assembleUrl(prefix, URLUtils.mapToQueryString(paramsMap, true, isUrlEncode));
    }

    public static String assembleProtocol(String funcName, Map<String, Object> paramsMap, boolean isUrlEncode) {
        return URLUtils.assembleUrl("cmblife://" + funcName, paramsMap, isUrlEncode);
    }

    public static String mapToQueryString(Map<String, Object> map, boolean isSort, boolean isUrlEncode) {
        Map<String, Object> tempMap;
        if (isSort) {
            tempMap = new TreeMap<String, Object>();
            tempMap.putAll(map);
        } else {
            tempMap = map;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : tempMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String valueStr = URLUtils.objectToString(value);
            if (StringUtils.isBlank(valueStr)) continue;
            if (isUrlEncode) {
                valueStr = StringUtils.urlEncode(valueStr);
            }
            if (!StringUtils.isNotBlank(valueStr)) continue;
            sb.append(key).append("=").append(valueStr).append("&");
        }
        String queryString = sb.toString();
        if (queryString.length() > 1) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        return queryString;
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return "";
        }
        return object instanceof Map || object instanceof Collection ? JsonUtils.objectToJson(object) : "" + object;
    }
}

