/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.aop.service.impl;

import com.codingapi.tx.aop.bean.TxTransactionInfo;
import com.codingapi.tx.aop.service.TransactionServer;
import com.codingapi.tx.aop.service.TransactionServerFactoryService;
import com.codingapi.tx.datasource.ILCNTransactionControl;
import com.codingapi.tx.netty.service.NettyService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionServerFactoryServiceImpl
implements TransactionServerFactoryService {
    @Autowired
    private TransactionServer txStartTransactionServer;
    @Autowired
    private TransactionServer txRunningTransactionServer;
    @Autowired
    private TransactionServer txDefaultTransactionServer;
    @Autowired
    private TransactionServer txRunningNoTransactionServer;
    @Autowired
    private NettyService nettyService;
    @Autowired
    private ILCNTransactionControl transactionControl;

    @Override
    public TransactionServer createTransactionServer(TxTransactionInfo info) throws Throwable {
        if (info.getTransaction() != null && info.getTransaction().isStart() && info.getTxTransactionLocal() == null && StringUtils.isEmpty((String)info.getTxGroupId())) {
            if (this.nettyService.checkState()) {
                return this.txStartTransactionServer;
            }
            throw new Exception("tx-manager not connected ,please check tx-manager server ");
        }
        if (info.getTxTransactionLocal() != null || StringUtils.isNotEmpty((String)info.getTxGroupId())) {
            if (this.nettyService.checkState()) {
                if (info.getTxTransactionLocal() != null) {
                    return this.txDefaultTransactionServer;
                }
                if (!this.transactionControl.isNoTransactionOperation()) {
                    return this.txRunningTransactionServer;
                }
                return this.txRunningNoTransactionServer;
            }
            throw new Exception("tx-manager not connected ,please check tx-manager server ");
        }
        return this.txDefaultTransactionServer;
    }
}

