/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.aop.service.impl;

import com.codingapi.tx.Constants;
import com.codingapi.tx.aop.bean.TxCompensateLocal;
import com.codingapi.tx.aop.bean.TxTransactionInfo;
import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.aop.service.TransactionServer;
import com.codingapi.tx.framework.task.TaskGroupManager;
import com.codingapi.tx.framework.task.TaskState;
import com.codingapi.tx.framework.task.TxTask;
import com.codingapi.tx.netty.service.MQTxManagerService;
import com.lorne.core.framework.utils.KidUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="txStartTransactionServer")
public class TxStartTransactionServerImpl
implements TransactionServer {
    private Logger logger = LoggerFactory.getLogger(TxStartTransactionServerImpl.class);
    @Autowired
    protected MQTxManagerService txManagerService;

    @Override
    public Object execute(ProceedingJoinPoint point, TxTransactionInfo info) throws Throwable {
        TxCompensateLocal compensateLocal;
        int lastState;
        int rs;
        String type;
        Object object;
        this.logger.debug("--->begin start transaction");
        long start = System.currentTimeMillis();
        int state = 0;
        String groupId = TxCompensateLocal.current() == null ? KidUtils.generateShortUuid() : TxCompensateLocal.current().getGroupId();
        this.txManagerService.createTransactionGroup(groupId);
        TxTransactionLocal txTransactionLocal = new TxTransactionLocal();
        txTransactionLocal.setGroupId(groupId);
        txTransactionLocal.setHasStart(true);
        txTransactionLocal.setMaxTimeOut(Constants.txServer.getCompensateMaxWaitTime());
        TxTransactionLocal.setCurrent(txTransactionLocal);
        try {
            Object obj = point.proceed();
            state = 1;
            object = obj;
            type = txTransactionLocal.getType();
            rs = this.txManagerService.closeTransactionGroup(groupId, state);
            lastState = rs == -1 ? 0 : state;
        }
        catch (Throwable e) {
            try {
                state = this.rollbackException(info, e);
                throw e;
            }
            catch (Throwable throwable) {
                TxCompensateLocal compensateLocal2;
                String type2 = txTransactionLocal.getType();
                int rs2 = this.txManagerService.closeTransactionGroup(groupId, state);
                int lastState2 = rs2 == -1 ? 0 : state;
                int executeConnectionError = 0;
                TxTask waitTask = TaskGroupManager.getInstance().getTask(groupId, type2);
                if (waitTask != null) {
                    waitTask.setState(lastState2);
                    waitTask.signalTask();
                    while (!waitTask.isRemove()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (waitTask.getState() == TaskState.connectionError.getCode()) {
                        executeConnectionError = 1;
                        lastState2 = 0;
                    }
                }
                if ((compensateLocal2 = TxCompensateLocal.current()) == null) {
                    long end = System.currentTimeMillis();
                    long time = end - start;
                    if (executeConnectionError == 1 && rs2 == 1 || lastState2 == 1 && rs2 == 0) {
                        this.txManagerService.sendCompensateMsg(groupId, time, info, executeConnectionError);
                    }
                } else {
                    lastState2 = rs2 == 1 ? 1 : 0;
                }
                TxTransactionLocal.setCurrent(null);
                this.logger.debug("<---end start transaction");
                this.logger.debug("start transaction over, res -> groupId:" + groupId + ", now state:" + (lastState2 == 1 ? "commit" : "rollback"));
                throw throwable;
            }
        }
        int executeConnectionError = 0;
        TxTask waitTask = TaskGroupManager.getInstance().getTask(groupId, type);
        if (waitTask != null) {
            waitTask.setState(lastState);
            waitTask.signalTask();
            while (!waitTask.isRemove()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (waitTask.getState() == TaskState.connectionError.getCode()) {
                executeConnectionError = 1;
                lastState = 0;
            }
        }
        if ((compensateLocal = TxCompensateLocal.current()) == null) {
            long end = System.currentTimeMillis();
            long time = end - start;
            if (executeConnectionError == 1 && rs == 1 || lastState == 1 && rs == 0) {
                this.txManagerService.sendCompensateMsg(groupId, time, info, executeConnectionError);
            }
        } else {
            lastState = rs == 1 ? 1 : 0;
        }
        TxTransactionLocal.setCurrent(null);
        this.logger.debug("<---end start transaction");
        this.logger.debug("start transaction over, res -> groupId:" + groupId + ", now state:" + (lastState == 1 ? "commit" : "rollback"));
        return object;
    }

    private int rollbackException(TxTransactionInfo info, Throwable throwable) {
        if (RuntimeException.class.isAssignableFrom(throwable.getClass())) {
            return 0;
        }
        if (Error.class.isAssignableFrom(throwable.getClass())) {
            return 0;
        }
        for (Class<? extends Throwable> rollbackFor : info.getTransaction().rollbackFor()) {
            if (!rollbackFor.isAssignableFrom(throwable.getClass())) continue;
            return 0;
        }
        for (Class<? extends Throwable> rollbackFor : info.getTransaction().noRollbackFor()) {
            if (!rollbackFor.isAssignableFrom(throwable.getClass())) continue;
            return 1;
        }
        return 1;
    }
}

