/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.netty.handler;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.tx.framework.utils.SocketManager;
import com.codingapi.tx.framework.utils.SocketUtils;
import com.codingapi.tx.netty.service.NettyControlService;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TransactionHandler
extends ChannelInboundHandlerAdapter {
    private Logger logger = LoggerFactory.getLogger(TransactionHandler.class);
    private NettyControlService nettyControlService;
    private String heartJson;
    private Executor threadPool;

    public TransactionHandler(Executor threadPool, NettyControlService nettyControlService, int delay) {
        this.threadPool = threadPool;
        this.nettyControlService = nettyControlService;
        SocketManager.getInstance().setDelay(delay);
        JSONObject heartJo = new JSONObject();
        heartJo.put("a", (Object)"h");
        heartJo.put("k", (Object)"h");
        heartJo.put("p", (Object)"{}");
        this.heartJson = heartJo.toString();
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        final String json = SocketUtils.getJson(msg);
        this.logger.debug("TxManager-response->" + json);
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                TransactionHandler.this.nettyControlService.executeService(ctx, json);
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.logger.info("disconnection  -->" + ctx);
        SocketManager.getInstance().setNetState(false);
        this.nettyControlService.restart();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        SocketManager.getInstance().setCtx(ctx);
        this.logger.info("connection -->" + ctx);
        SocketUtils.sendMsg(ctx, this.heartJson);
        this.nettyControlService.uploadModelInfo();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && (event = (IdleStateEvent)evt).state() != IdleState.READER_IDLE) {
            if (event.state() == IdleState.WRITER_IDLE) {
                SocketUtils.sendMsg(ctx, this.heartJson);
                this.logger.debug("hart data --->" + this.heartJson);
            } else if (event.state() == IdleState.ALL_IDLE) {
                // empty if block
            }
        }
    }
}

