/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.netty.service;

import com.codingapi.tx.netty.service.TxManagerHttpRequestService;
import com.lorne.core.framework.utils.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TxManagerHttpRequestHelper {
    private TxManagerHttpRequestService httpRequestService;
    @Autowired
    private ApplicationContext spring;
    private Logger logger = LoggerFactory.getLogger(TxManagerHttpRequestHelper.class);

    private void reloadHttpRequestService() {
        try {
            this.httpRequestService = (TxManagerHttpRequestService)this.spring.getBean(TxManagerHttpRequestService.class);
        }
        catch (Exception e) {
            this.logger.debug("load default httpRequestService ");
        }
        if (this.httpRequestService == null) {
            this.httpRequestService = new TxManagerHttpRequestService(){

                @Override
                public String httpGet(String url) {
                    return HttpUtils.get((String)url);
                }

                @Override
                public String httpPost(String url, String params) {
                    return HttpUtils.post((String)url, (String)params);
                }
            };
            this.logger.info("load default HttpRequestService .");
        } else {
            this.logger.info("load HttpRequestService .");
        }
    }

    public String httpGet(String url) {
        this.reloadHttpRequestService();
        return this.httpRequestService.httpGet(url);
    }

    public String httpPost(String url, String params) {
        this.reloadHttpRequestService();
        return this.httpRequestService.httpPost(url, params);
    }
}

