/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.netty.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.tx.control.service.TransactionControlService;
import com.codingapi.tx.framework.utils.SocketManager;
import com.codingapi.tx.listener.service.ModelNameService;
import com.codingapi.tx.netty.service.MQTxManagerService;
import com.codingapi.tx.netty.service.NettyControlService;
import com.codingapi.tx.netty.service.NettyService;
import com.codingapi.tx.netty.utils.IpAddressUtils;
import com.lorne.core.framework.utils.task.ConditionUtils;
import com.lorne.core.framework.utils.task.IBack;
import com.lorne.core.framework.utils.task.Task;
import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NettyControlServiceImpl
implements NettyControlService {
    @Autowired
    private NettyService nettyService;
    @Autowired
    private TransactionControlService transactionControlService;
    @Autowired
    private MQTxManagerService mqTxManagerService;
    @Autowired
    private ModelNameService modelNameService;

    @Override
    public void restart() {
        this.nettyService.close();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.nettyService.start();
    }

    @Override
    public void uploadModelInfo() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!SocketManager.getInstance().isNetState() || !IpAddressUtils.isIpAddress(NettyControlServiceImpl.this.modelNameService.getIpAddress())) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                NettyControlServiceImpl.this.mqTxManagerService.uploadModelInfo();
            }
        }).start();
    }

    @Override
    public void executeService(ChannelHandlerContext ctx, String json) {
        if (StringUtils.isNotEmpty((String)json)) {
            JSONObject resObj = JSONObject.parseObject((String)json);
            if (resObj.containsKey((Object)"a")) {
                this.transactionControlService.notifyTransactionMsg(ctx, resObj, json);
            } else {
                String key = resObj.getString("k");
                this.responseMsg(key, resObj);
            }
        }
    }

    private void responseMsg(String key, JSONObject resObj) {
        if (!"h".equals(key)) {
            final String data = resObj.getString("d");
            Task task = ConditionUtils.getInstance().getTask(key);
            if (task != null && task.isAwait()) {
                task.setBack(new IBack(){

                    public Object doing(Object ... objs) throws Throwable {
                        return data;
                    }
                });
                task.signalTask();
            }
        } else {
            String data = resObj.getString("d");
            SocketManager.getInstance().setNetState(true);
            if (StringUtils.isNotEmpty((String)data)) {
                try {
                    SocketManager.getInstance().setDelay(Integer.parseInt(data));
                }
                catch (Exception e) {
                    SocketManager.getInstance().setDelay(1);
                }
            }
        }
    }
}

