/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.netty.service.impl;

import com.codingapi.tx.Constants;
import com.codingapi.tx.model.TxServer;
import com.codingapi.tx.netty.service.MQTxManagerService;
import com.codingapi.tx.netty.service.NettyDistributeService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NettyDistributeServiceImpl
implements NettyDistributeService {
    private int connectCont = 0;
    private Logger logger = LoggerFactory.getLogger(NettyDistributeServiceImpl.class);
    @Autowired
    private MQTxManagerService txManagerService;

    @Override
    public synchronized void loadTxServer() {
        if (Constants.txServer == null) {
            this.getTxServer();
            return;
        }
        ++this.connectCont;
        if (this.connectCont == 3) {
            this.getTxServer();
        }
    }

    private void getTxServer() {
        String json = null;
        while (StringUtils.isEmpty(json)) {
            json = this.txManagerService.httpGetServer();
            this.logger.info("get txManager ->" + json);
            if (!StringUtils.isEmpty((String)json)) continue;
            this.logger.error("TxManager\u670d\u52a1\u5668\u65e0\u6cd5\u8bbf\u95ee.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TxServer txServer = TxServer.parser(json);
        if (txServer != null) {
            this.logger.debug("txServer -> " + txServer);
            this.logger.info(txServer.toString());
            Constants.txServer = txServer;
            this.logger.info(Constants.txServer.toString());
            this.connectCont = 0;
        }
    }
}

