/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.relational;

import com.codingapi.tx.aop.bean.TxCompensateLocal;
import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.datasource.AbstractResourceProxy;
import com.codingapi.tx.datasource.ICallClose;
import com.codingapi.tx.datasource.ILCNConnection;
import com.codingapi.tx.datasource.ILCNResource;
import com.codingapi.tx.datasource.relational.LCNDBConnection;
import com.codingapi.tx.datasource.relational.LCNStartConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LCNTransactionDataSource
extends AbstractResourceProxy<Connection, LCNDBConnection>
implements ILCNConnection {
    private Logger logger = LoggerFactory.getLogger(LCNTransactionDataSource.class);

    protected Connection createLcnConnection(Connection connection, TxTransactionLocal txTransactionLocal) {
        ++this.nowCount;
        if (txTransactionLocal.isHasStart()) {
            LCNStartConnection lcnStartConnection = new LCNStartConnection(connection, (ICallClose<ILCNResource>)this.subNowCount);
            this.logger.debug("get new start connection - > " + txTransactionLocal.getGroupId());
            this.pools.put(txTransactionLocal.getGroupId(), lcnStartConnection);
            txTransactionLocal.setHasConnection(true);
            return lcnStartConnection;
        }
        LCNDBConnection lcn = new LCNDBConnection(connection, this.dataSourceService, (ICallClose<ILCNResource>)this.subNowCount);
        this.logger.debug("get new connection ->" + txTransactionLocal.getGroupId());
        this.pools.put(txTransactionLocal.getGroupId(), lcn);
        txTransactionLocal.setHasConnection(true);
        return lcn;
    }

    protected void initDbType() {
        TxCompensateLocal txCompensateLocal;
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        if (txTransactionLocal != null) {
            txTransactionLocal.setType("datasource");
        }
        if ((txCompensateLocal = TxCompensateLocal.current()) != null) {
            txCompensateLocal.setType("datasource");
        }
    }

    public Connection getConnection(ProceedingJoinPoint point) throws Throwable {
        this.hasTransaction = true;
        this.initDbType();
        Connection connection = (Connection)this.loadConnection();
        if (connection == null) {
            connection = (Connection)this.initLCNConnection((Connection)point.proceed());
            if (connection == null) {
                throw new SQLException("connection was overload");
            }
            return connection;
        }
        return connection;
    }
}

