/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.config;

import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="tx-lcn.manager")
@Component
public class TxManagerConfig {
    public static final int PORT_CHANGE_VALUE = 100;
    private String host = "127.0.0.1";
    private int port;
    private long heartTime = 300000L;
    private int concurrentLevel;
    private long dtxLockTime = -1L;
    private long dtxTime = 8000L;
    private String adminKey = "codingapi";
    private boolean exUrlEnabled = true;
    private String exUrl = "/provider/email-to/ujued@qq.com";
    private int seqLen = 12;
    private long machineId;

    @Autowired
    public TxManagerConfig(ServerProperties serverProperties) {
        this.port = Objects.requireNonNull(serverProperties.getPort(), "TM http port not configured?") + 100;
    }

    private void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    public void applyMachineId(long machineId) {
        this.setMachineId(machineId);
    }

    public long getDtxLockTime() {
        return this.dtxLockTime == -1L ? this.dtxTime : this.dtxLockTime;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public long getHeartTime() {
        return this.heartTime;
    }

    public int getConcurrentLevel() {
        return this.concurrentLevel;
    }

    public long getDtxTime() {
        return this.dtxTime;
    }

    public String getAdminKey() {
        return this.adminKey;
    }

    public boolean isExUrlEnabled() {
        return this.exUrlEnabled;
    }

    public String getExUrl() {
        return this.exUrl;
    }

    public int getSeqLen() {
        return this.seqLen;
    }

    public long getMachineId() {
        return this.machineId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHeartTime(long heartTime) {
        this.heartTime = heartTime;
    }

    public void setConcurrentLevel(int concurrentLevel) {
        this.concurrentLevel = concurrentLevel;
    }

    public void setDtxLockTime(long dtxLockTime) {
        this.dtxLockTime = dtxLockTime;
    }

    public void setDtxTime(long dtxTime) {
        this.dtxTime = dtxTime;
    }

    public void setAdminKey(String adminKey) {
        this.adminKey = adminKey;
    }

    public void setExUrlEnabled(boolean exUrlEnabled) {
        this.exUrlEnabled = exUrlEnabled;
    }

    public void setExUrl(String exUrl) {
        this.exUrl = exUrl;
    }

    public void setSeqLen(int seqLen) {
        this.seqLen = seqLen;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxManagerConfig)) {
            return false;
        }
        TxManagerConfig other = (TxManagerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getHeartTime() != other.getHeartTime()) {
            return false;
        }
        if (this.getConcurrentLevel() != other.getConcurrentLevel()) {
            return false;
        }
        if (this.getDtxLockTime() != other.getDtxLockTime()) {
            return false;
        }
        if (this.getDtxTime() != other.getDtxTime()) {
            return false;
        }
        String this$adminKey = this.getAdminKey();
        String other$adminKey = other.getAdminKey();
        if (this$adminKey == null ? other$adminKey != null : !this$adminKey.equals(other$adminKey)) {
            return false;
        }
        if (this.isExUrlEnabled() != other.isExUrlEnabled()) {
            return false;
        }
        String this$exUrl = this.getExUrl();
        String other$exUrl = other.getExUrl();
        if (this$exUrl == null ? other$exUrl != null : !this$exUrl.equals(other$exUrl)) {
            return false;
        }
        if (this.getSeqLen() != other.getSeqLen()) {
            return false;
        }
        return this.getMachineId() == other.getMachineId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxManagerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        long $heartTime = this.getHeartTime();
        result = result * 59 + (int)($heartTime >>> 32 ^ $heartTime);
        result = result * 59 + this.getConcurrentLevel();
        long $dtxLockTime = this.getDtxLockTime();
        result = result * 59 + (int)($dtxLockTime >>> 32 ^ $dtxLockTime);
        long $dtxTime = this.getDtxTime();
        result = result * 59 + (int)($dtxTime >>> 32 ^ $dtxTime);
        String $adminKey = this.getAdminKey();
        result = result * 59 + ($adminKey == null ? 43 : $adminKey.hashCode());
        result = result * 59 + (this.isExUrlEnabled() ? 79 : 97);
        String $exUrl = this.getExUrl();
        result = result * 59 + ($exUrl == null ? 43 : $exUrl.hashCode());
        result = result * 59 + this.getSeqLen();
        long $machineId = this.getMachineId();
        result = result * 59 + (int)($machineId >>> 32 ^ $machineId);
        return result;
    }

    public String toString() {
        return "TxManagerConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", heartTime=" + this.getHeartTime() + ", concurrentLevel=" + this.getConcurrentLevel() + ", dtxLockTime=" + this.getDtxLockTime() + ", dtxTime=" + this.getDtxTime() + ", adminKey=" + this.getAdminKey() + ", exUrlEnabled=" + this.isExUrlEnabled() + ", exUrl=" + this.getExUrl() + ", seqLen=" + this.getSeqLen() + ", machineId=" + this.getMachineId() + ")";
    }
}

