/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.support.service.impl;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.tm.support.service.ManagerService;
import com.codingapi.txlcn.tm.txmsg.MessageCreator;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.params.NotifyConnectParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagerServiceImpl
implements ManagerService {
    private static final Logger log = LoggerFactory.getLogger(ManagerServiceImpl.class);
    private final RpcClient rpcClient;
    private final FastStorage fastStorage;
    private final TxManagerConfig managerConfig;

    @Autowired
    public ManagerServiceImpl(RpcClient rpcClient, FastStorage fastStorage, TxManagerConfig managerConfig) {
        this.rpcClient = rpcClient;
        this.fastStorage = fastStorage;
        this.managerConfig = managerConfig;
    }

    @Override
    public boolean refresh(NotifyConnectParams notifyConnectParams) throws RpcException {
        List keys = this.rpcClient.loadAllRemoteKey();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                this.rpcClient.send(key, MessageCreator.newTxManager(notifyConnectParams));
            }
        }
        return true;
    }

    @Override
    public long machineIdSync() throws TxManagerException {
        long id;
        long machineMaxSize = (-1L << 63 - this.managerConfig.getSeqLen() ^ 0xFFFFFFFFFFFFFFFFL) - 1L;
        long timeout = this.managerConfig.getHeartTime() + 2000L;
        try {
            id = this.fastStorage.acquireMachineId(machineMaxSize, timeout);
        }
        catch (FastStorageException e) {
            throw new TxManagerException((Throwable)e);
        }
        log.info("Acquired machine id {}, max machine id is: {}", (Object)id, (Object)machineMaxSize);
        return id;
    }

    @Override
    public void refreshMachines(long ... machineId) throws TxManagerException {
        long timeout = this.managerConfig.getHeartTime() + 2000L;
        this.fastStorage.refreshMachines(timeout, machineId);
    }
}

