/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg.transaction;

import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.common.util.id.ModIdProvider;
import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.support.service.ManagerService;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.RpcConfig;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.params.InitClientParams;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_init-client")
public class InitClientService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(InitClientService.class);
    private final RpcClient rpcClient;
    private final TxManagerConfig txManagerConfig;
    private final RpcConfig rpcConfig;
    private final ManagerService managerService;
    private final ModIdProvider modIdProvider;

    @Autowired
    public InitClientService(RpcClient rpcClient, TxManagerConfig txManagerConfig, RpcConfig rpcConfig, ManagerService managerService, ModIdProvider modIdProvider) {
        this.rpcClient = rpcClient;
        this.txManagerConfig = txManagerConfig;
        this.rpcConfig = rpcConfig;
        this.managerService = managerService;
        this.modIdProvider = modIdProvider;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        InitClientParams initClientParams = (InitClientParams)transactionCmd.getMsg().loadBean(InitClientParams.class);
        log.info("Registered TC: {}", (Object)initClientParams.getLabelName());
        try {
            this.rpcClient.bindAppName(transactionCmd.getRemoteKey(), initClientParams.getAppName(), initClientParams.getLabelName());
        }
        catch (RpcException e) {
            throw new TxManagerException((Throwable)e);
        }
        initClientParams.setSeqLen(this.txManagerConfig.getSeqLen());
        initClientParams.setMachineId(this.managerService.machineIdSync());
        initClientParams.setDtxTime(this.txManagerConfig.getDtxTime());
        initClientParams.setTmRpcTimeout(this.rpcConfig.getWaitTime());
        initClientParams.setAppName(this.modIdProvider.modId());
        return initClientParams;
    }
}

