/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.time;

import com.couchbase.client.core.time.ExponentialDelay;
import com.couchbase.client.core.time.FixedDelay;
import com.couchbase.client.core.time.LinearDelay;
import java.util.concurrent.TimeUnit;

public abstract class Delay {
    private final TimeUnit unit;

    Delay(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit is not allowed to be null");
        }
        this.unit = unit;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public abstract long calculate(long var1);

    public static Delay fixed(long delay, TimeUnit unit) {
        return new FixedDelay(delay, unit);
    }

    public static Delay linear(TimeUnit unit) {
        return Delay.linear(unit, Long.MAX_VALUE);
    }

    public static Delay linear(TimeUnit unit, long upper) {
        return Delay.linear(unit, upper, 0L);
    }

    public static Delay linear(TimeUnit unit, long upper, long lower) {
        return Delay.linear(unit, upper, lower, 1L);
    }

    public static Delay linear(TimeUnit unit, long upper, long lower, long growBy) {
        return new LinearDelay(unit, upper, lower, growBy);
    }

    public static Delay exponential(TimeUnit unit) {
        return Delay.exponential(unit, Long.MAX_VALUE);
    }

    public static Delay exponential(TimeUnit unit, long upper) {
        return Delay.exponential(unit, upper, 0L);
    }

    public static Delay exponential(TimeUnit unit, long upper, long lower) {
        return Delay.exponential(unit, upper, lower, 1L);
    }

    public static Delay exponential(TimeUnit unit, long upper, long lower, long growBy) {
        return new ExponentialDelay(unit, upper, lower, growBy);
    }
}

