/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.refresher.AbstractRefresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.Buffers;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class CarrierRefresher
extends AbstractRefresher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CarrierRefresher.class);
    private final Set<String> subscriptions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final CoreEnvironment environment;
    private volatile Subscription pollerSubscription;
    private volatile long nodeOffset;
    private final Map<String, Long> lastPollTimestamps;
    private final long pollFloorNs;

    public CarrierRefresher(CoreEnvironment environment, ClusterFacade cluster) {
        super(environment, cluster);
        this.environment = environment;
        this.lastPollTimestamps = new ConcurrentHashMap<String, Long>();
        this.nodeOffset = 0L;
        this.pollFloorNs = TimeUnit.MILLISECONDS.toNanos(environment.configPollFloorInterval());
        long pollInterval = environment.configPollInterval();
        if (pollInterval > 0L) {
            LOGGER.debug("Starting polling with interval {}ms", (Object)pollInterval);
            this.pollerSubscription = Observable.interval((long)pollInterval, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)environment.scheduler()).subscribe((Action1)new Action1<Long>(){

                public void call(Long aLong) {
                    CarrierRefresher.this.provider().signalOutdated();
                }
            });
        } else {
            LOGGER.info("Proactive config polling disabled based on environment setting.");
        }
    }

    @Override
    public Observable<Boolean> shutdown() {
        LOGGER.debug("Shutting down the CarrierRefresher.");
        return Observable.just((Object)true).doOnNext((Action1)new Action1<Boolean>(){

            public void call(Boolean ignored) {
                if (CarrierRefresher.this.pollerSubscription != null && !CarrierRefresher.this.pollerSubscription.isUnsubscribed()) {
                    CarrierRefresher.this.pollerSubscription.unsubscribe();
                }
            }
        });
    }

    @Override
    public void markTainted(final BucketConfig config) {
        final String bucketName = config.name();
        if (this.subscriptions.contains(bucketName)) {
            return;
        }
        LOGGER.debug("Config for bucket \"" + bucketName + "\" marked as tainted, starting polling.");
        this.subscriptions.add(bucketName);
        Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).takeWhile((Func1)new Func1<Long, Boolean>(){

            public Boolean call(Long aLong) {
                return CarrierRefresher.this.subscriptions.contains(bucketName);
            }
        }).filter((Func1)new Func1<Long, Boolean>(){

            public Boolean call(Long aLong) {
                boolean allowed = CarrierRefresher.this.allowedToPoll(bucketName);
                if (allowed) {
                    CarrierRefresher.this.lastPollTimestamps.put(bucketName, System.nanoTime());
                } else {
                    LOGGER.trace("Ignoring tainted polling attempt because poll interval is too small.");
                }
                return allowed;
            }
        }).flatMap((Func1)new Func1<Long, Observable<String>>(){

            public Observable<String> call(Long aLong) {
                ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(config.nodes());
                if (nodeInfos.isEmpty()) {
                    LOGGER.debug("Cannot poll bucket, because node list contains no nodes.");
                    return Observable.empty();
                }
                CarrierRefresher.this.shiftNodeList(nodeInfos);
                return CarrierRefresher.this.buildRefreshFallbackSequence(nodeInfos, bucketName);
            }
        }).subscribe((Subscriber)new Subscriber<String>(){

            public void onCompleted() {
                LOGGER.debug("Completed polling for bucket \"{}\".", (Object)bucketName);
            }

            public void onError(Throwable e) {
                LOGGER.debug("Error while polling bucket config, ignoring.", e);
            }

            public void onNext(String rawConfig) {
                if (rawConfig.startsWith("{")) {
                    CarrierRefresher.this.provider().proposeBucketConfig(bucketName, rawConfig);
                }
            }
        });
    }

    @Override
    public void markUntainted(BucketConfig config) {
        if (this.subscriptions.contains(config.name())) {
            LOGGER.debug("Config for bucket \"" + config.name() + "\" marked as untainted, stopping polling.");
            this.subscriptions.remove(config.name());
        }
    }

    @Override
    public void refresh(ClusterConfig config) {
        Observable.from(config.bucketConfigs().values()).observeOn(this.environment.scheduler()).filter((Func1)new Func1<BucketConfig, Boolean>(){

            public Boolean call(BucketConfig config) {
                return CarrierRefresher.this.registrations().containsKey(config.name());
            }
        }).filter((Func1)new Func1<BucketConfig, Boolean>(){

            public Boolean call(BucketConfig config) {
                String bucketName = config.name();
                boolean allowed = CarrierRefresher.this.allowedToPoll(bucketName);
                if (allowed) {
                    CarrierRefresher.this.lastPollTimestamps.put(bucketName, System.nanoTime());
                } else {
                    LOGGER.trace("Ignoring refresh polling attempt because poll interval is too small.");
                }
                return allowed;
            }
        }).subscribe((Action1)new Action1<BucketConfig>(){

            public void call(final BucketConfig config) {
                final String bucketName = config.name();
                ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(config.nodes());
                if (nodeInfos.isEmpty()) {
                    LOGGER.debug("Cannot refresh bucket, because node list contains no nodes.");
                    return;
                }
                CarrierRefresher.this.shiftNodeList(nodeInfos);
                Observable refreshSequence = CarrierRefresher.this.buildRefreshFallbackSequence(nodeInfos, bucketName);
                refreshSequence.subscribe((Subscriber)new Subscriber<String>(){

                    public void onCompleted() {
                        LOGGER.debug("Completed refreshing config for bucket \"{}\"", (Object)bucketName);
                    }

                    public void onError(Throwable e) {
                        LOGGER.debug("Error while refreshing bucket config, ignoring.", e);
                    }

                    public void onNext(String rawConfig) {
                        if (rawConfig.startsWith("{")) {
                            CarrierRefresher.this.provider().proposeBucketConfig(config.name(), rawConfig);
                        }
                    }
                });
            }
        });
    }

    private Observable<String> buildRefreshFallbackSequence(List<NodeInfo> nodeInfos, String bucketName) {
        Observable failbackSequence = null;
        for (NodeInfo nodeInfo : nodeInfos) {
            if (!CarrierRefresher.isValidCarrierNode(this.environment.sslEnabled(), nodeInfo)) continue;
            if (failbackSequence == null) {
                failbackSequence = this.refreshAgainstNode(bucketName, nodeInfo.hostname());
                continue;
            }
            failbackSequence = failbackSequence.onErrorResumeNext(this.refreshAgainstNode(bucketName, nodeInfo.hostname()));
        }
        if (failbackSequence == null) {
            LOGGER.debug("Could not build refresh sequence, node list is empty - ignoring attempt.");
            return Observable.empty();
        }
        return failbackSequence;
    }

    <T> void shiftNodeList(List<T> nodeList) {
        int shiftBy = (int)(this.nodeOffset++ % (long)nodeList.size());
        for (int i = 0; i < shiftBy; ++i) {
            T element = nodeList.remove(0);
            nodeList.add(element);
        }
    }

    private static boolean isValidCarrierNode(boolean sslEnabled, NodeInfo nodeInfo) {
        if (sslEnabled && nodeInfo.sslServices().containsKey((Object)ServiceType.BINARY)) {
            return true;
        }
        return nodeInfo.services().containsKey((Object)ServiceType.BINARY);
    }

    private boolean allowedToPoll(String bucket) {
        Long bucketLastPollTimestamp = this.lastPollTimestamps.get(bucket);
        return bucketLastPollTimestamp == null || System.nanoTime() - bucketLastPollTimestamp >= this.pollFloorNs;
    }

    private Observable<String> refreshAgainstNode(final String bucketName, final NetworkAddress hostname) {
        return Buffers.wrapColdWithAutoRelease(Observable.defer((Func0)new Func0<Observable<GetBucketConfigResponse>>(){

            public Observable<GetBucketConfigResponse> call() {
                return CarrierRefresher.this.cluster().send(new GetBucketConfigRequest(bucketName, hostname));
            }
        })).doOnNext((Action1)new Action1<GetBucketConfigResponse>(){

            public void call(GetBucketConfigResponse response) {
                if (!response.status().isSuccess()) {
                    if (response.content() != null && response.content().refCnt() > 0) {
                        response.content().release();
                    }
                    throw new ConfigurationException("Could not fetch config from node: " + response);
                }
            }
        }).map((Func1)new Func1<GetBucketConfigResponse, String>(){

            public String call(GetBucketConfigResponse response) {
                String raw = response.content().toString(CharsetUtil.UTF_8).trim();
                if (response.content().refCnt() > 0) {
                    response.content().release();
                }
                return raw.replace("$HOST", response.hostname().address());
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable ex) {
                LOGGER.debug("Could not fetch config from bucket \"" + bucketName + "\" against \"" + hostname + "\".", ex);
            }
        });
    }

    Subscription pollerSubscription() {
        return this.pollerSubscription;
    }
}

