/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.service.AbstractDynamicService;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.state.LifecycleState;
import rx.Subscriber;
import rx.functions.Action1;

public abstract class AbstractOnDemandService
extends AbstractDynamicService {
    protected AbstractOnDemandService(String hostname, String bucket, String username, String password, int port, CoreContext ctx, Service.EndpointFactory endpointFactory) {
        super(hostname, bucket, username, password, port, ctx, 0, endpointFactory);
    }

    @Override
    protected void dispatch(final CouchbaseRequest request) {
        final Endpoint endpoint = this.createEndpoint();
        this.endpointStates().register(endpoint, endpoint);
        endpoint.connect().subscribe((Subscriber)new Subscriber<LifecycleState>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                request.observable().onError(e);
            }

            public void onNext(LifecycleState lifecycleState) {
                if (lifecycleState == LifecycleState.DISCONNECTED) {
                    request.observable().onError((Throwable)new CouchbaseException("Could not connect endpoint."));
                }
            }
        });
        AbstractOnDemandService.whenState(endpoint, LifecycleState.CONNECTED, new Action1<LifecycleState>(){

            public void call(LifecycleState lifecycleState) {
                endpoint.send(request);
                endpoint.send(SignalFlush.INSTANCE);
            }
        });
        AbstractOnDemandService.whenState(endpoint, LifecycleState.DISCONNECTED, new Action1<LifecycleState>(){

            public void call(LifecycleState lifecycleState) {
                AbstractOnDemandService.this.endpointStates().deregister(endpoint);
            }
        });
    }
}

