/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.state.AbstractStateZipper;
import com.couchbase.client.core.state.LifecycleState;
import java.util.Collection;

public class ServiceStateZipper
extends AbstractStateZipper<Service, LifecycleState> {
    private final LifecycleState initialState;

    public ServiceStateZipper(LifecycleState initial) {
        super(initial);
        this.initialState = initial;
    }

    @Override
    protected LifecycleState zipWith(Collection<LifecycleState> states) {
        if (states.isEmpty()) {
            return LifecycleState.DISCONNECTED;
        }
        int connected = 0;
        int connecting = 0;
        int disconnecting = 0;
        int idle = 0;
        int degraded = 0;
        block8: for (LifecycleState serviceState : states) {
            switch (serviceState) {
                case CONNECTED: {
                    ++connected;
                    continue block8;
                }
                case CONNECTING: {
                    ++connecting;
                    continue block8;
                }
                case DISCONNECTING: {
                    ++disconnecting;
                    continue block8;
                }
                case DEGRADED: {
                    ++degraded;
                    continue block8;
                }
                case IDLE: {
                    ++idle;
                }
                case DISCONNECTED: {
                    continue block8;
                }
            }
            throw new IllegalStateException("Unknown unhandled state " + (Object)((Object)serviceState) + ", this is a bug!");
        }
        if (states.size() == idle) {
            return LifecycleState.IDLE;
        }
        if (states.size() == connected + idle) {
            return LifecycleState.CONNECTED;
        }
        if (connected > 0 || degraded > 0) {
            return LifecycleState.DEGRADED;
        }
        if (connecting > 0) {
            return LifecycleState.CONNECTING;
        }
        if (disconnecting > 0) {
            return LifecycleState.DISCONNECTING;
        }
        return LifecycleState.DISCONNECTED;
    }
}

