/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.tracing;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.service.ServiceType;
import java.util.Map;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class RingBufferDiagnostics {
    private final Map<ServiceType, Integer> counts;
    private final int countNonService;

    @InterfaceAudience.Public
    @InterfaceStability.Experimental
    public Map<ServiceType, Integer> counts() {
        return this.counts;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Experimental
    public int countNonService() {
        return this.countNonService;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Experimental
    public int totalCount() {
        int total = this.countNonService;
        for (Map.Entry<ServiceType, Integer> entry : this.counts.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Experimental
    public RingBufferDiagnostics(Map<ServiceType, Integer> counts, int countNonService) {
        this.counts = counts;
        this.countNonService = countNonService;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int total = this.countNonService;
        for (Map.Entry<ServiceType, Integer> entry : this.counts.entrySet()) {
            total += entry.getValue().intValue();
            sb.append(entry.getKey().name()).append('=').append(entry.getValue()).append(' ');
        }
        sb.append("other=").append(this.countNonService).append(" total=").append(total);
        return sb.toString();
    }
}

