/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.io;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.io.IoContext;
import java.time.Duration;

public class InvalidPacketDetectedEvent
extends AbstractEvent {
    private final byte[] packet;

    public InvalidPacketDetectedEvent(IoContext context, byte[] packet) {
        super(Event.Severity.ERROR, Event.Category.IO, Duration.ZERO, (Context)context);
        this.packet = packet;
    }

    @Override
    public String description() {
        return "Invalid Packet detected: \n" + ByteBufUtil.prettyHexDump(Unpooled.copiedBuffer(this.packet)) + "\n";
    }

    public byte[] packet() {
        return this.packet;
    }
}

